# Contribution FAQ

## General

### Can I discuss my contribution ideas somewhere?

Sure thing! You can either open an Enhancement Proposal in our GitHub issue tracker or you can [join us on Slack](https://argoproj.github.io/community/join-slack) in channel #argo-contributors to discuss your ideas and get guidance for submitting a PR.

!!! note
    Regular [contributor meetings](https://argo-cd.readthedocs.io/en/latest/developer-guide/code-contributions/#regular-contributor-meeting) are held weekly. Please follow the link for more details.

### No one has looked at my PR yet. Why?

As we have limited resources, it can sometimes take a while for someone to respond to your PR. Especially, when your PR contains complex or non-obvious changes. Please bear with us, we try to look at every PR that we receive. Kindly ensure all applicable requirements have been met in your PR checklist.

### How do I get my PR labeled `ready-for-review` ?

Conventionally an initial review is performed from a Argo member or reviewer. Once the initial review is approved, it can be labeled `ready-for-review` and then added to the [Argo CD Review](https://github.com/orgs/argoproj/projects/28) Github project. Details of the project dashboard can be found [here](https://github.com/orgs/argoproj/projects/28?pane=info).

High quality reviews are extremely encouraged from the community. A member/reviewer may work with a community reviewer to get a PR labeled `ready-for-review`. It can then be added to the project dashboard and marked `Community Reviewed`.

### Why has my PR been declined? I put so much work into it!

We appreciate that you have put your valuable time and know how into a contribution. Alas, some changes do not fit into the overall ArgoCD philosophy, and therefore can't be merged into the official ArgoCD source tree.

To be on the safe side, make sure that you have created an Enhancement Proposal for your change before starting to work on your PR and have gathered enough feedback from the community and the maintainers.

### A check on my PR is failing.
See [Failing CI Checks](ci.md#troubleshooting-ci-checks).

### What checked-in code is generated, and how is it generated?
The following files under this repository are generated, and must be kept up-to-date. Also see [Why does the codegen step fail?](ci.md#why-does-the-codegen-step-fail).

See the Makefile for targets that can also run these scripts, and the `codegen` target which runs them all.

| Filename | Purpose | Generated by |
| -------- | ------- | ------------ |
| `*.pb.go`, `*.pb.gw.go` | [Protobuf](https://developers.google.com/protocol-buffers/docs/gotutorial) Interfaces | `hack/generate-proto.sh` |
| `assets/swagger.json` | Swagger 2 API spec | `hack/update-openapi.sh` |
| `manifests/` | k8s Installation Manifests | `hack/update-manifests.sh` |
| `docs/user-guide/commands` | CLI Documentation | `tools/cmd-docs/main.go` |
