# v2.5 to 2.6

## Known Issues

### Broken `project` filter before 2.6.6

Argo CD 2.4.0 introduced a breaking API change, renaming the `project` filter to `projects`.

#### Impact to API clients

A similar issue applies to other API clients which communicate with the Argo CD API server via its REST API. If the
client uses the `project` field to filter projects, the filter will not be applied. **The failing project filter could
have detrimental consequences if, for example, you rely on it to list Applications to be deleted.**

#### Impact to CLI clients

CLI clients older that v2.4.0 rely on client-side filtering and are not impacted by this bug.

#### How to fix the problem

Upgrade to Argo CD >=2.4.27, >=2.5.15, or >=2.6.6. This version of Argo CD will accept both `project` and `projects` as
valid filters.

### Broken matrix-nested git files generator in 2.6.5

Argo CD 2.6.5 introduced a bug in the matrix-nested git files generator. The bug only applies when the git files 
generator is the second generator nested under a matrix. For example:

```yaml
apiVersion: argoproj.io/v1alpha1
kind: ApplicationSet
metadata:
  name: guestbook
spec:
  generators:
  - matrix:
      generators:
        - clusters: {}
        - git:
            repoURL: https://git.example.com/org/repo.git
            revision: HEAD
            files:
              - path: "defaults/*.yaml"
  template:
    # ...
```

The nested git files generator will produce no parameters, causing the matrix generator to also produce no parameters.
This will cause the ApplicationSet to produce no Applications. If the ApplicationSet controller is 
[configured with the ability to delete applications](https://argo-cd.readthedocs.io/en/latest/operator-manual/applicationset/Controlling-Resource-Modification/), 
it will delete all Applications which were previously created by the ApplicationSet.

To avoid this issue, upgrade directly to >=2.5.15 or >= 2.6.6.

## ApplicationSets: `^` behavior change in Sprig's semver functions
Argo CD 2.5 introduced [Go templating in ApplicationSets](https://argo-cd.readthedocs.io/en/stable/operator-manual/applicationset/GoTemplate/). Go templates have access to the Sprig function library.

Argo CD 2.6 upgrades Sprig to v3. That upgrade includes an upgrade of [Masterminds/semver](https://github.com/Masterminds/semver/releases) to v3.

Masterminds/semver v3 changed the behavior of the `^` prefix in semantic version constraints. If you are using Go-templated ApplicationSets which include references to [Sprig's semver functions](https://masterminds.github.io/sprig/semver.html) and use the `^` prefix, read the [Masterminds/semver changelog](https://github.com/Masterminds/semver/releases/tag/v3.0.0) to understand how your ApplicationSets' behavior may change.

## Applications with suspended jobs now marked "Suspended" instead of "Progressing"
Prior to Argo CD v2.6, an Application managing a suspended Job would be marked as "Progressing". This was confusing/unexpected behavior for many. Starting with v2.6, Argo CD will mark such Applications as "Suspended".

If you have processes which rely on the previous behavior (for example, a CI job with an argocd app wait call), update those before upgrading to v2.6.

## The API Server now requires tokens to include the `aud` claim by default

Argo CD v2.6 now requires that the `aud` claim be present in the token used to authenticate to the API Server. This is a 
security improvement, as it prevents tokens from being used against the API Server which were not intended for it.

If you rely on an OIDC provider which does not provide a `aud` claim, you can disable this requirement by setting the 
`skipAudienceCheckWhenTokenHasNoAudience` flag to `true` in your Argo CD OIDC configuration. (See the 
[OIDC configuration documentation](https://argo-cd.readthedocs.io/en/stable/operator-manual/user-management/#existing-oidc-provider)
for an example.)

## Removal of argocd-cm plugin support delayed until 2.7

Support for argocd-cm plugins was previously scheduled for 2.6. At the time, sidecar plugins could not be specified by
name. Argo CD v2.6 introduces support for specifying sidecar plugins by name. 

Removal of argocd-cm plugin support has been delayed until 2.7 to provide a transition time for users who need to 
specify plugins by name. 

## `argocd app create` for old CLI versions fails with API version >=2.6.7

Starting with Argo CD 2.6.7, the API returns `PermissionDenied` instead of `NotFound` for Application `GET` requests if
the Application does not exist.

The Argo CD CLI before versions starting with version 2.5.0-rc1 and before versions 2.5.16 and 2.6.7 does a `GET`
request before the `POST` request in `argocd app create`. The command does not gracefully handle the `PermissionDenied`
response and will therefore fail to create/update the Application.

To solve the issue, upgrade the CLI to at least 2.5.16, or 2.6.7.

CLIs older than 2.5.0-rc1 are unaffected.

