/*
 * This file is part of the KDE Baloo Project
 * Copyright (C) 2013  Vishesh Handa <me@vhanda.in>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) version 3, or any
 * later version accepted by the membership of KDE e.V. (or its
 * successor approved by the membership of KDE e.V.), which shall
 * act as a proxy defined in Section 6 of version 3 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef EXTRACTOR_APP_H
#define EXTRACTOR_APP_H

#include <QVector>
#include <QStringList>
#include <QMimeDatabase>
#include <QTextStream>
#include <QSocketNotifier>
#include <QDBusMessage>
#include <QDBusServiceWatcher>

#include <KFileMetaData/ExtractorCollection>

#include "database.h"
#include "../fileindexerconfig.h"
#include "iohandler.h"

namespace Baloo {

class Transaction;

class App : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.baloo.extractor")
    Q_PROPERTY(QString currentUrl READ currentUrl NOTIFY currentUrlChanged)

public:
    explicit App(const QString& path, QObject* parent = 0);
    QString currentUrl() const { return m_currentUrl; }

Q_SIGNALS:
    Q_SCRIPTABLE void currentUrlChanged(QString url);

private Q_SLOTS:
    void slotNewInput();
    void unregisterMonitor(const QString& service);

public Q_SLOTS:
    Q_SCRIPTABLE void registerMonitor(const QDBusMessage& message);

private:
    void index(Transaction* tr, const QString& filePath, quint64 id);

    QString m_path;
    QMimeDatabase m_mimeDb;

    KFileMetaData::ExtractorCollection m_extractorCollection;

    FileIndexerConfig m_config;

    QSocketNotifier m_notifyNewData;
    IOHandler m_io;

    QString m_currentUrl;
    QStringList m_monitors;
    QDBusServiceWatcher m_monitorsWatcher;
};

}
#endif
