
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Normalize document using Node.normalize with element-content-whitespace set to false and validation set to true, check that
 * whitespace in element content is preserved.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-normalize">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-normalize</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-element-content-whitespace">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-element-content-whitespace</a>
*/
public final class elementcontentwhitespace03 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementcontentwhitespace03(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList bodyList;
      Element body;
      DOMConfiguration domConfig;
      boolean canSet;
      boolean canSetValidate;
      org.w3c.domts.DOMErrorMonitor errorMonitor = new org.w3c.domts.DOMErrorMonitor();
      
      Node child;
      String childName;
      Text text;
      doc = (Document) load("barfoo", true);
      domConfig = doc.getDomConfig();
      
      if (isIgnoringElementContentWhitespace()) {
          bodyList = doc.getElementsByTagName("body");
      body = (Element) bodyList.item(0);
      child = body.getFirstChild();
      text = doc.createTextNode("    ");
      child = body.insertBefore(text, child);
      }
    canSet = domConfig.canSetParameter("element-content-whitespace", Boolean.FALSE);
      
      if (canSet) {
          domConfig.setParameter("element-content-whitespace", Boolean.FALSE);
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorMonitor */errorMonitor));
      doc.normalize();
      errorMonitor.assertLowerSeverity(this, "normalizeError", 2);
     bodyList = doc.getElementsByTagName("body");
      body = (Element) bodyList.item(0);
      child = body.getFirstChild();
      assertNotNull("firstChildNotNull", child);
      childName = child.getNodeName();
      assertEquals("firstChild", "#text", childName);
      child = child.getNextSibling();
      assertNotNull("secondChildNotNull", child);
      childName = child.getNodeName();
      assertEquals("secondChild", "p", childName);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementcontentwhitespace03";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementcontentwhitespace03.class, args);
   }
}

