
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The normalizeDocument method method acts as if the document was going through a save 
 *  and load cycle, putting the document in a "normal" form. 
 *  Create an Element and a text node and verify the nodeValue of this text node and append these to
 *  this Document.  If supported, invoke the setParameter method on this domconfiguration object to set the 
 *  "element-content-whitespace"  feature to false.  Invoke the normalizeDocument method and verify if 
 *  the text node has been discarded.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-element-content-whitespace">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-element-content-whitespace</a>
*/
public final class documentnormalizedocument10 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentnormalizedocument10(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element elem;
      Text newText;
      Text text;
      String nodeValue;
      boolean canSet;
      Node appendedChild;
      DOMConfiguration domConfig;
      doc = (Document) load("hc_staff", false);
      elem = doc.createElement("newElem");
      newText = doc.createTextNode("Text          Node");
      appendedChild = elem.appendChild(newText);
      appendedChild = doc.appendChild(elem);
      text = (Text) elem.getFirstChild();
      nodeValue = text.getNodeValue();
      assertEquals("documentnormalizedocument10", "Text          Node", nodeValue);
      domConfig = doc.getDomConfig();
      canSet = domConfig.canSetParameter("element-content-whitespace", Boolean.TRUE);
      assertTrue("canSetElementContentWhitespaceTrue", canSet);
      domConfig.setParameter("element-content-whitespace", Boolean.TRUE);
      doc.normalizeDocument();
      text = (Text) elem.getFirstChild();
      nodeValue = text.getNodeValue();
      assertEquals("documentnormalizedocument10_true1", "Text          Node", nodeValue);
      canSet = domConfig.canSetParameter("element-content-whitespace", Boolean.FALSE);
      
      if (canSet) {
          domConfig.setParameter("element-content-whitespace", Boolean.FALSE);
      doc.normalizeDocument();
      text = (Text) elem.getFirstChild();
      nodeValue = text.getNodeValue();
      assertEquals("documentnormalizedocument10_true2", "Text Node", nodeValue);
      }
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentnormalizedocument10";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentnormalizedocument10.class, args);
   }
}

