/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.html;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.io.Characters;
import com.google.gxp.html.HtmlClosure;
import com.google.i18n.Localizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class HtmlClosures {
    public static final HtmlClosure EMPTY = new HtmlClosure(){

        @Override
        public void write(Appendable out, GxpContext context) {
        }
    };

    private HtmlClosures() {
    }

    public static final HtmlClosure fromHtml(final String html) {
        Preconditions.checkNotNull(html);
        return new HtmlClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                out.append(html);
            }
        };
    }

    public static final HtmlClosure fromPlaintext(final String text) {
        Preconditions.checkNotNull(text);
        return new HtmlClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                CharEscapers.asciiHtmlEscaper().escape(out).append(text);
            }
        };
    }

    public static final HtmlClosure fromLocalizable(final Localizable value) {
        Preconditions.checkNotNull(value);
        return new HtmlClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                CharEscapers.asciiHtmlEscaper().escape(out).append(value.toString(gxpContext.getLocale()));
            }
        };
    }

    public static final HtmlClosure fromFile(final File file, final Charset charset) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new HtmlClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, charset);
                Characters.copy(isr, out);
                isr.close();
                fis.close();
            }
        };
    }

    public static final HtmlClosure fromReader(final Reader reader) throws IOException {
        Preconditions.checkNotNull(reader);
        return new HtmlClosure(){
            private boolean firstCall = true;

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                if (!this.firstCall) {
                    reader.reset();
                }
                this.firstCall = false;
                Characters.copy(reader, out);
            }
        };
    }

    public static final HtmlClosure concat(Iterable<? extends HtmlClosure> closures) {
        Preconditions.checkContentsNotNull(closures);
        final ImmutableList<? extends HtmlClosure> closuresCopy = ImmutableList.copyOf(closures);
        return new HtmlClosure(){

            @Override
            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                for (HtmlClosure closure : closuresCopy) {
                    closure.write(out, gxpContext);
                }
            }
        };
    }

    public static final HtmlClosure concat(HtmlClosure ... closures) {
        return HtmlClosures.concat(ImmutableList.of(closures));
    }
}

