/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.simple;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.example.simple.CachedQueue;

public class RandomAsyncCommit {
    private final ConcurrentHashMap<MessageQueue, CachedQueue> mqCachedTable = new ConcurrentHashMap();

    public void putMessages(MessageQueue mq, List<MessageExt> msgs) {
        CachedQueue cachedQueue = this.mqCachedTable.get(mq);
        if (null == cachedQueue) {
            cachedQueue = new CachedQueue();
            this.mqCachedTable.put(mq, cachedQueue);
        }
        for (MessageExt msg : msgs) {
            cachedQueue.getMsgCachedTable().put(msg.getQueueOffset(), msg);
        }
    }

    public void removeMessage(MessageQueue mq, long offset) {
        CachedQueue cachedQueue = this.mqCachedTable.get(mq);
        if (null != cachedQueue) {
            cachedQueue.getMsgCachedTable().remove(offset);
        }
    }

    public long commitableOffset(MessageQueue mq) {
        CachedQueue cachedQueue = this.mqCachedTable.get(mq);
        if (null != cachedQueue) {
            return cachedQueue.getMsgCachedTable().firstKey();
        }
        return -1L;
    }
}

