/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.simple;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.store.ReadOffsetType;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class PullConsumer {
    public static void main(String[] args) throws MQClientException {
        final DefaultMQPullConsumer consumer = new DefaultMQPullConsumer("please_rename_unique_group_name_5");
        consumer.setNamesrvAddr("127.0.0.1:9876");
        HashSet<String> topics = new HashSet<String>();
        topics.add("TopicTest");
        consumer.setRegisterTopics(topics);
        consumer.start();
        ExecutorService executors = Executors.newFixedThreadPool(topics.size(), (ThreadFactory)new ThreadFactoryImpl("PullConsumerThread"));
        for (final String topic : consumer.getRegisterTopics()) {
            executors.execute(new Runnable(){

                public void doSomething(List<MessageExt> msgs) {
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            block15: while (true) {
                                if ((messageQueues = consumer.fetchMessageQueuesInBalance(topic)) == null || messageQueues.isEmpty()) {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                pullResult = null;
                                var3_6 = messageQueues.iterator();
                                while (true) {
                                    if (var3_6.hasNext()) ** break;
                                    continue block15;
                                    messageQueue = (MessageQueue)var3_6.next();
                                    try {
                                        offset = this.consumeFromOffset(messageQueue);
                                        pullResult = consumer.pull(messageQueue, "*", offset, 32);
                                        switch (2.$SwitchMap$org$apache$rocketmq$client$consumer$PullStatus[pullResult.getPullStatus().ordinal()]) {
                                            case 1: {
                                                msgs = pullResult.getMsgFoundList();
                                                if (msgs == null || msgs.isEmpty()) break;
                                                this.doSomething(msgs);
                                                consumer.updateConsumeOffset(messageQueue, pullResult.getNextBeginOffset());
                                                this.incPullTPS(topic, pullResult.getMsgFoundList().size());
                                                break;
                                            }
                                            case 2: {
                                                consumer.updateConsumeOffset(messageQueue, pullResult.getNextBeginOffset());
                                                break;
                                            }
                                            case 3: {
                                                Thread.sleep(1L);
                                                consumer.updateConsumeOffset(messageQueue, pullResult.getNextBeginOffset());
                                                break;
                                            }
                                            case 4: {
                                                consumer.updateConsumeOffset(messageQueue, pullResult.getNextBeginOffset());
                                                break;
                                            }
                                        }
                                    }
                                    catch (RemotingException e) {
                                        e.printStackTrace();
                                    }
                                    catch (MQBrokerException e) {
                                        e.printStackTrace();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                break;
                            }
                        }
                        catch (MQClientException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }

                public long consumeFromOffset(MessageQueue messageQueue) throws MQClientException {
                    long offset = consumer.getOffsetStore().readOffset(messageQueue, ReadOffsetType.READ_FROM_MEMORY);
                    if (offset < 0L) {
                        offset = consumer.getOffsetStore().readOffset(messageQueue, ReadOffsetType.READ_FROM_STORE);
                    }
                    if (offset < 0L) {
                        offset = consumer.maxOffset(messageQueue);
                    }
                    if (offset < 0L) {
                        offset = 0L;
                    }
                    return offset;
                }

                public void incPullTPS(String topic2, int pullSize) {
                    consumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getConsumerStatsManager().incPullTPS(consumer.getConsumerGroup(), topic2, (long)pullSize);
                }
            });
        }
    }
}

