/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.kv;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.HeartbeatRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class MessageFetcher
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final RemotingClient client;

    public MessageFetcher() {
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        nettyClientConfig.setUseTLS(false);
        this.client = new NettyRemotingClient(nettyClientConfig);
        this.client.start();
    }

    @Override
    public void close() throws IOException {
        this.client.shutdown();
    }

    private PullMessageRequestHeader createPullMessageRequest(String topic, int queueId, long queueOffset, long subVersion) {
        int sysFlag = PullSysFlag.buildSysFlag((boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
        PullMessageRequestHeader requestHeader = new PullMessageRequestHeader();
        requestHeader.setConsumerGroup(this.getConsumerGroup(topic, queueId));
        requestHeader.setTopic(topic);
        requestHeader.setQueueId(Integer.valueOf(queueId));
        requestHeader.setQueueOffset(Long.valueOf(queueOffset));
        requestHeader.setMaxMsgNums(Integer.valueOf(10));
        requestHeader.setSysFlag(Integer.valueOf(sysFlag));
        requestHeader.setCommitOffset(Long.valueOf(0L));
        requestHeader.setSuspendTimeoutMillis(Long.valueOf(20000L));
        requestHeader.setSubVersion(Long.valueOf(subVersion));
        requestHeader.setMaxMsgBytes(Integer.valueOf(Integer.MAX_VALUE));
        return requestHeader;
    }

    private String getConsumerGroup(String topic, int queueId) {
        return String.join((CharSequence)"-", topic, String.valueOf(queueId), "pull", "group");
    }

    private String getClientId() {
        return String.join((CharSequence)"@", NetworkUtil.getLocalAddress(), "compactionIns", "compactionUnit");
    }

    private boolean prepare(String masterAddr, String topic, String groupName, long subVersion) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        HeartbeatData heartbeatData = new HeartbeatData();
        heartbeatData.setClientID(this.getClientId());
        ConsumerData consumerData = new ConsumerData();
        consumerData.setGroupName(groupName);
        consumerData.setConsumeType(ConsumeType.CONSUME_ACTIVELY);
        consumerData.setMessageModel(MessageModel.CLUSTERING);
        consumerData.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString("*");
        subscriptionData.setSubVersion(subVersion);
        consumerData.setSubscriptionDataSet((Set)Sets.newHashSet((Object[])new SubscriptionData[]{subscriptionData}));
        heartbeatData.getConsumerDataSet().add(consumerData);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, (CommandCustomHeader)new HeartbeatRequestHeader());
        request.setLanguage(LanguageCode.JAVA);
        request.setBody(heartbeatData.encode());
        RemotingCommand response = this.client.invokeSync(masterAddr, request, 30000L);
        return response != null && response.getCode() == 0;
    }

    private boolean pullDone(String masterAddr, String groupName) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        UnregisterClientRequestHeader requestHeader = new UnregisterClientRequestHeader();
        requestHeader.setClientID(this.getClientId());
        requestHeader.setProducerGroup("");
        requestHeader.setConsumerGroup(groupName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)35, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.client.invokeSync(masterAddr, request, 30000L);
        return response != null && response.getCode() == 0;
    }

    private boolean stopPull(long currPullOffset, long endOffset) {
        return currPullOffset >= endOffset && endOffset != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pullMessageFromMaster(String topic, int queueId, long endOffset, String masterAddr, BiFunction<Long, RemotingCommand, Boolean> responseHandler) throws Exception {
        long currentPullOffset = 0L;
        try {
            long subVersion = System.currentTimeMillis();
            String groupName = this.getConsumerGroup(topic, queueId);
            if (!this.prepare(masterAddr, topic, groupName, subVersion)) {
                log.error("{}:{} prepare to {} pull message failed", new Object[]{topic, queueId, masterAddr});
                throw new RemotingCommandException(topic + ":" + queueId + " prepare to " + masterAddr + " pull message failed");
            }
            boolean noNewMsg = false;
            boolean keepPull = true;
            while (!this.stopPull(currentPullOffset, endOffset)) {
                PullMessageRequestHeader requestHeader = this.createPullMessageRequest(topic, queueId, currentPullOffset, subVersion);
                RemotingCommand request = RemotingCommand.createRequestCommand((int)361, (CommandCustomHeader)requestHeader);
                RemotingCommand response = this.client.invokeSync(masterAddr, request, 30000L);
                PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.decodeCommandCustomHeader(PullMessageResponseHeader.class);
                if (responseHeader == null) {
                    log.error("{}:{} pull message responseHeader is null", (Object)topic, (Object)queueId);
                    throw new RemotingCommandException(topic + ":" + queueId + " pull message responseHeader is null");
                }
                switch (response.getCode()) {
                    case 0: {
                        long curOffset = responseHeader.getNextBeginOffset() - 1L;
                        keepPull = responseHandler.apply(curOffset, response);
                        currentPullOffset = responseHeader.getNextBeginOffset();
                        break;
                    }
                    case 19: {
                        log.info("PULL_NOT_FOUND, topic:{}, queueId:{}, pullOffset:{},", new Object[]{topic, queueId, currentPullOffset});
                        noNewMsg = true;
                        break;
                    }
                    case 20: {
                        log.info("PULL_RETRY_IMMEDIATE, topic:{}, queueId:{}, pullOffset:{},", new Object[]{topic, queueId, currentPullOffset});
                        break;
                    }
                    case 21: {
                        log.info("PULL_OFFSET_MOVED, topic:{}, queueId:{}, pullOffset:{},", new Object[]{topic, queueId, currentPullOffset});
                        break;
                    }
                    default: {
                        log.warn("Pull Message error, response code: {}, remark: {}", (Object)response.getCode(), (Object)response.getRemark());
                    }
                }
                if (!noNewMsg && keepPull) continue;
                break;
            }
            this.pullDone(masterAddr, groupName);
            if (this.client == null) return;
        }
        catch (Throwable throwable) {
            if (this.client == null) throw throwable;
            this.client.closeChannels((List)Lists.newArrayList((Object[])new String[]{masterAddr}));
            throw throwable;
        }
        this.client.closeChannels((List)Lists.newArrayList((Object[])new String[]{masterAddr}));
    }
}

