/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.storage.snapshot.local;

import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RetryAgainException;
import com.alipay.sofa.jraft.storage.SnapshotThrottle;
import com.alipay.sofa.jraft.storage.io.LocalDirReader;
import com.alipay.sofa.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.ByteBufferCollector;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SnapshotFileReader
extends LocalDirReader {
    private final SnapshotThrottle snapshotThrottle;
    private LocalSnapshotMetaTable metaTable;

    public SnapshotFileReader(String path, SnapshotThrottle snapshotThrottle) {
        super(path);
        this.snapshotThrottle = snapshotThrottle;
    }

    public LocalSnapshotMetaTable getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(LocalSnapshotMetaTable metaTable) {
        this.metaTable = metaTable;
    }

    public boolean open() {
        File file = new File(this.getPath());
        return file.exists();
    }

    @Override
    public int readFile(ByteBufferCollector metaBufferCollector, String fileName, long offset, long maxCount) throws IOException, RetryAgainException {
        if (fileName.equals("__raft_snapshot_meta")) {
            ByteBuffer metaBuf = this.metaTable.saveToByteBufferAsRemote();
            BufferUtils.position(metaBuf, metaBuf.limit());
            metaBufferCollector.setBuffer(metaBuf);
            return -1;
        }
        LocalFileMetaOutter.LocalFileMeta fileMeta = this.metaTable.getFileMeta(fileName);
        if (fileMeta == null) {
            throw new FileNotFoundException("LocalFileMeta not found for " + fileName);
        }
        long newMaxCount = maxCount;
        if (this.snapshotThrottle != null && (newMaxCount = this.snapshotThrottle.throttledByThroughput(maxCount)) < maxCount && newMaxCount == 0L) {
            throw new RetryAgainException("readFile throttled by throughput");
        }
        return this.readFileWithMeta(metaBufferCollector, fileName, (Message)fileMeta, offset, newMaxCount);
    }
}

