/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc;

import com.alipay.remoting.CustomSerializer;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.sofa.jraft.rpc.ProtobufMsgFactory;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.google.protobuf.Message;

public class ProtobufSerializer
implements CustomSerializer {
    public static final ProtobufSerializer INSTANCE = new ProtobufSerializer();

    public <T extends RequestCommand> boolean serializeHeader(T request, InvokeContext invokeContext) throws SerializationException {
        RpcRequestCommand cmd = (RpcRequestCommand)request;
        Message msg = (Message)cmd.getRequestObject();
        if (msg instanceof RpcRequests.AppendEntriesRequest) {
            RpcRequests.AppendEntriesRequest req = (RpcRequests.AppendEntriesRequest)msg;
            RpcRequests.AppendEntriesRequestHeader.Builder hb = RpcRequests.AppendEntriesRequestHeader.newBuilder().setGroupId(req.getGroupId()).setPeerId(req.getPeerId()).setServerId(req.getServerId());
            cmd.setHeader(hb.build().toByteArray());
            return true;
        }
        return false;
    }

    public <T extends ResponseCommand> boolean serializeHeader(T response) throws SerializationException {
        return false;
    }

    public <T extends RequestCommand> boolean deserializeHeader(T request) throws DeserializationException {
        RpcRequestCommand cmd = (RpcRequestCommand)request;
        String className = cmd.getRequestClass();
        if (className.equals(RpcRequests.AppendEntriesRequest.class.getName())) {
            byte[] header = cmd.getHeader();
            cmd.setRequestHeader(ProtobufMsgFactory.newMessageByJavaClassName(RpcRequests.AppendEntriesRequestHeader.class.getName(), header));
            return true;
        }
        return false;
    }

    public <T extends ResponseCommand> boolean deserializeHeader(T response, InvokeContext invokeContext) throws DeserializationException {
        return false;
    }

    public <T extends RequestCommand> boolean serializeContent(T request, InvokeContext invokeContext) throws SerializationException {
        RpcRequestCommand cmd = (RpcRequestCommand)request;
        Message msg = (Message)cmd.getRequestObject();
        cmd.setContent(msg.toByteArray());
        return true;
    }

    public <T extends ResponseCommand> boolean serializeContent(T response) throws SerializationException {
        RpcResponseCommand cmd = (RpcResponseCommand)response;
        Message msg = (Message)cmd.getResponseObject();
        cmd.setContent(msg.toByteArray());
        return true;
    }

    public <T extends RequestCommand> boolean deserializeContent(T request) throws DeserializationException {
        RpcRequestCommand cmd = (RpcRequestCommand)request;
        String className = cmd.getRequestClass();
        cmd.setRequestObject(ProtobufMsgFactory.newMessageByJavaClassName(className, request.getContent()));
        return true;
    }

    public <T extends ResponseCommand> boolean deserializeContent(T response, InvokeContext invokeContext) throws DeserializationException {
        RpcResponseCommand cmd = (RpcResponseCommand)response;
        String className = cmd.getResponseClass();
        cmd.setResponseObject(ProtobufMsgFactory.newMessageByJavaClassName(className, response.getContent()));
        return true;
    }
}

