/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.metrics.PopReviveMessageType;
import org.apache.rocketmq.broker.processor.PopBufferMergeService;
import org.apache.rocketmq.broker.processor.PopReviveService;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopMetricsManager {
    private static final Logger log = LoggerFactory.getLogger(PopMetricsManager.class);
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    private static LongHistogram popBufferScanTimeConsume;
    private static LongCounter popRevivePutTotal;
    private static LongCounter popReviveGetTotal;
    private static LongCounter popReviveRetryMessageTotal;

    public static List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List<Double> rpcCostTimeBuckets = Arrays.asList(Duration.ofMillis(1L).toMillis(), Duration.ofMillis(10L).toMillis(), Duration.ofMillis(100L).toMillis(), Duration.ofSeconds(1L).toMillis(), Duration.ofSeconds(2L).toMillis(), Duration.ofSeconds(3L).toMillis());
        InstrumentSelector popBufferScanTimeConsumeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_pop_buffer_scan_time_consume").build();
        ViewBuilder popBufferScanTimeConsumeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(rpcCostTimeBuckets));
        return Lists.newArrayList((Object[])new Pair[]{new Pair((Object)popBufferScanTimeConsumeSelector, (Object)popBufferScanTimeConsumeViewBuilder)});
    }

    public static void initMetrics(Meter meter, BrokerController brokerController, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        PopMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        popBufferScanTimeConsume = meter.histogramBuilder("rocketmq_pop_buffer_scan_time_consume").setDescription("Time consuming of pop buffer scan").setUnit("milliseconds").ofLongs().build();
        popRevivePutTotal = meter.counterBuilder("rocketmq_pop_revive_in_message_total").setDescription("Total number of put message to revive topic").build();
        popReviveGetTotal = meter.counterBuilder("rocketmq_pop_revive_out_message_total").setDescription("Total number of get message from revive topic").build();
        popReviveRetryMessageTotal = meter.counterBuilder("rocketmq_pop_revive_retry_messages_total").setDescription("Total number of put message to pop retry topic").build();
        meter.gaugeBuilder("rocketmq_pop_offset_buffer_size").setDescription("Time number of buffered offset").ofLongs().buildWithCallback(measurement -> PopMetricsManager.calculatePopBufferOffsetSize(brokerController, measurement));
        meter.gaugeBuilder("rocketmq_pop_checkpoint_buffer_size").setDescription("The number of buffered checkpoint").ofLongs().buildWithCallback(measurement -> PopMetricsManager.calculatePopBufferCkSize(brokerController, measurement));
        meter.gaugeBuilder("rocketmq_pop_revive_lag").setDescription("The processing lag of revive topic").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> PopMetricsManager.calculatePopReviveLag(brokerController, measurement));
        meter.gaugeBuilder("rocketmq_pop_revive_latency").setDescription("The processing latency of revive topic").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> PopMetricsManager.calculatePopReviveLatency(brokerController, measurement));
    }

    private static void calculatePopBufferOffsetSize(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopBufferMergeService popBufferMergeService = brokerController.getPopMessageProcessor().getPopBufferMergeService();
        measurement.record((long)popBufferMergeService.getOffsetTotalSize(), PopMetricsManager.newAttributesBuilder().build());
    }

    private static void calculatePopBufferCkSize(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopBufferMergeService popBufferMergeService = brokerController.getPopMessageProcessor().getPopBufferMergeService();
        measurement.record((long)popBufferMergeService.getBufferedCKSize(), PopMetricsManager.newAttributesBuilder().build());
    }

    private static void calculatePopReviveLatency(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopReviveService[] popReviveServices;
        for (PopReviveService popReviveService : popReviveServices = brokerController.getAckMessageProcessor().getPopReviveServices()) {
            try {
                measurement.record(popReviveService.getReviveBehindMillis(), PopMetricsManager.newAttributesBuilder().put("queue_id", (long)popReviveService.getQueueId()).build());
            }
            catch (ConsumeQueueException e) {
                log.error("Failed to get revive behind duration", (Throwable)e);
            }
        }
    }

    private static void calculatePopReviveLag(BrokerController brokerController, ObservableLongMeasurement measurement) {
        PopReviveService[] popReviveServices;
        for (PopReviveService popReviveService : popReviveServices = brokerController.getAckMessageProcessor().getPopReviveServices()) {
            try {
                measurement.record(popReviveService.getReviveBehindMessages(), PopMetricsManager.newAttributesBuilder().put("queue_id", (long)popReviveService.getQueueId()).build());
            }
            catch (ConsumeQueueException e) {
                log.error("Failed to get revive behind message count", (Throwable)e);
            }
        }
    }

    public static void incPopReviveAckPutCount(AckMsg ackMsg, PutMessageStatus status) {
        PopMetricsManager.incPopRevivePutCount(ackMsg.getConsumerGroup(), ackMsg.getTopic(), PopReviveMessageType.ACK, status, 1);
    }

    public static void incPopReviveCkPutCount(PopCheckPoint checkPoint, PutMessageStatus status) {
        PopMetricsManager.incPopRevivePutCount(checkPoint.getCId(), checkPoint.getTopic(), PopReviveMessageType.CK, status, 1);
    }

    public static void incPopRevivePutCount(String group, String topic, PopReviveMessageType messageType, PutMessageStatus status, int num) {
        Attributes attributes = PopMetricsManager.newAttributesBuilder().put("consumer_group", group).put("topic", topic).put("revive_message_type", messageType.name()).put("put_status", status.name()).build();
        popRevivePutTotal.add((long)num, attributes);
    }

    public static void incPopReviveAckGetCount(AckMsg ackMsg, int queueId) {
        PopMetricsManager.incPopReviveGetCount(ackMsg.getConsumerGroup(), ackMsg.getTopic(), PopReviveMessageType.ACK, queueId, 1);
    }

    public static void incPopReviveCkGetCount(PopCheckPoint checkPoint, int queueId) {
        PopMetricsManager.incPopReviveGetCount(checkPoint.getCId(), checkPoint.getTopic(), PopReviveMessageType.CK, queueId, 1);
    }

    public static void incPopReviveGetCount(String group, String topic, PopReviveMessageType messageType, int queueId, int num) {
        AttributesBuilder builder = PopMetricsManager.newAttributesBuilder();
        Attributes attributes = builder.put("consumer_group", group).put("topic", topic).put("queue_id", (long)queueId).put("revive_message_type", messageType.name()).build();
        popReviveGetTotal.add((long)num, attributes);
    }

    public static void incPopReviveRetryMessageCount(PopCheckPoint checkPoint, PutMessageStatus status) {
        AttributesBuilder builder = PopMetricsManager.newAttributesBuilder();
        Attributes attributes = builder.put("consumer_group", checkPoint.getCId()).put("topic", checkPoint.getTopic()).put("put_status", status.name()).build();
        popReviveRetryMessageTotal.add(1L, attributes);
    }

    public static void recordPopBufferScanTimeConsume(long time) {
        popBufferScanTimeConsume.record(time, PopMetricsManager.newAttributesBuilder().build());
    }

    public static AttributesBuilder newAttributesBuilder() {
        return attributesBuilderSupplier != null ? attributesBuilderSupplier.get() : Attributes.builder();
    }

    static {
        popBufferScanTimeConsume = new NopLongHistogram();
        popRevivePutTotal = new NopLongCounter();
        popReviveGetTotal = new NopLongCounter();
        popReviveRetryMessageTotal = new NopLongCounter();
    }
}

