/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.coldctr;

import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class ColdDataPullRequestHoldService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqColdCtr");
    public static final String NO_SUSPEND_KEY = "_noSuspend_";
    private final long coldHoldTimeoutMillis = 3000L;
    private final SystemClock systemClock = new SystemClock();
    private final BrokerController brokerController;
    private final LinkedBlockingQueue<PullRequest> pullRequestColdHoldQueue = new LinkedBlockingQueue(10000);

    public void suspendColdDataReadRequest(PullRequest pullRequest) {
        if (this.brokerController.getMessageStoreConfig().isColdDataFlowControlEnable()) {
            this.pullRequestColdHoldQueue.offer(pullRequest);
        }
    }

    public ColdDataPullRequestHoldService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public String getServiceName() {
        return ColdDataPullRequestHoldService.class.getSimpleName();
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            try {
                if (!this.brokerController.getMessageStoreConfig().isColdDataFlowControlEnable()) {
                    this.waitForRunning(20000L);
                } else {
                    this.waitForRunning(5000L);
                }
                long beginClockTimestamp = this.systemClock.now();
                this.checkColdDataPullRequest();
                long costTime = this.systemClock.now() - beginClockTimestamp;
                log.info("[{}] checkColdDataPullRequest-cost {} ms.", (Object)(costTime > 5000L ? "NOTIFYME" : "OK"), (Object)costTime);
            }
            catch (Throwable e) {
                log.warn(this.getServiceName() + " service has exception", e);
            }
        }
        log.info("{} service end", (Object)this.getServiceName());
    }

    private void checkColdDataPullRequest() {
        int succTotal = 0;
        int errorTotal = 0;
        int queueSize = this.pullRequestColdHoldQueue.size();
        Iterator<PullRequest> iterator = this.pullRequestColdHoldQueue.iterator();
        while (iterator.hasNext()) {
            PullRequest pullRequest = iterator.next();
            if (System.currentTimeMillis() < pullRequest.getSuspendTimestamp() + 3000L) continue;
            try {
                pullRequest.getRequestCommand().addExtField(NO_SUSPEND_KEY, "1");
                this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(pullRequest.getClientChannel(), pullRequest.getRequestCommand());
                ++succTotal;
            }
            catch (Exception e) {
                log.error("PullRequestColdHoldService checkColdDataPullRequest error", (Throwable)e);
                ++errorTotal;
            }
            iterator.remove();
        }
        log.info("checkColdPullRequest-info-finish, queueSize: {} successTotal: {} errorTotal: {}", new Object[]{queueSize, succTotal, errorTotal});
    }
}

