/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.model;

import com.alipay.hessian.generic.util.ClassFilter;
import java.io.Serializable;

public final class GenericArray
implements Serializable {
    private static final long serialVersionUID = 2584912495844320855L;
    private String type;
    private String componentType;
    private Object[] objects;

    private GenericArray() {
    }

    public GenericArray(String componentType) {
        this.componentType = this.getActualComponentType(componentType);
        this.type = "[" + ClassFilter.encodeObjectAndDate(componentType);
    }

    private String getActualComponentType(String componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3anull.");
        }
        int lastIndex = componentType.lastIndexOf(91);
        if (lastIndex != -1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < lastIndex + 1; ++i) {
                sb.append('[');
            }
            sb.append("L");
            sb.append(componentType.substring(lastIndex + 1));
            sb.append(";");
            return sb.toString();
        }
        return componentType;
    }

    public String getType() {
        return this.type;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public int getLength() {
        return this.objects.length;
    }

    public void setObjects(Object[] objects) {
        this.objects = objects;
    }

    public Object get(int idx) {
        return this.objects[idx];
    }

    public Object[] getObjects() {
        return this.objects;
    }
}

