/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.auth.config.AuthConfig;
import org.apache.rocketmq.common.future.FutureTaskExt;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.thread.ThreadPoolStatusMonitor;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.ClientHousekeepingService;
import org.apache.rocketmq.proxy.remoting.MultiProtocolRemotingServer;
import org.apache.rocketmq.proxy.remoting.RemotingProxyOutClient;
import org.apache.rocketmq.proxy.remoting.activity.AckMessageActivity;
import org.apache.rocketmq.proxy.remoting.activity.ChangeInvisibleTimeActivity;
import org.apache.rocketmq.proxy.remoting.activity.ClientManagerActivity;
import org.apache.rocketmq.proxy.remoting.activity.ConsumerManagerActivity;
import org.apache.rocketmq.proxy.remoting.activity.GetTopicRouteActivity;
import org.apache.rocketmq.proxy.remoting.activity.PopMessageActivity;
import org.apache.rocketmq.proxy.remoting.activity.PullMessageActivity;
import org.apache.rocketmq.proxy.remoting.activity.RecallMessageActivity;
import org.apache.rocketmq.proxy.remoting.activity.SendMessageActivity;
import org.apache.rocketmq.proxy.remoting.activity.TransactionActivity;
import org.apache.rocketmq.proxy.remoting.channel.RemotingChannelManager;
import org.apache.rocketmq.proxy.remoting.pipeline.AuthenticationPipeline;
import org.apache.rocketmq.proxy.remoting.pipeline.AuthorizationPipeline;
import org.apache.rocketmq.proxy.remoting.pipeline.ContextInitPipeline;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class RemotingProtocolServer
implements StartAndShutdown,
RemotingProxyOutClient {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final MessagingProcessor messagingProcessor;
    protected final RemotingChannelManager remotingChannelManager;
    protected final ChannelEventListener clientHousekeepingService;
    protected final RemotingServer defaultRemotingServer;
    protected final GetTopicRouteActivity getTopicRouteActivity;
    protected final ClientManagerActivity clientManagerActivity;
    protected final ConsumerManagerActivity consumerManagerActivity;
    protected final SendMessageActivity sendMessageActivity;
    protected final RecallMessageActivity recallMessageActivity;
    protected final TransactionActivity transactionActivity;
    protected final PullMessageActivity pullMessageActivity;
    protected final PopMessageActivity popMessageActivity;
    protected final AckMessageActivity ackMessageActivity;
    protected final ChangeInvisibleTimeActivity changeInvisibleTimeActivity;
    protected final ThreadPoolExecutor sendMessageExecutor;
    protected final ThreadPoolExecutor pullMessageExecutor;
    protected final ThreadPoolExecutor heartbeatExecutor;
    protected final ThreadPoolExecutor updateOffsetExecutor;
    protected final ThreadPoolExecutor topicRouteExecutor;
    protected final ThreadPoolExecutor defaultExecutor;
    protected final ScheduledExecutorService timerExecutor;

    public RemotingProtocolServer(MessagingProcessor messagingProcessor) {
        this.messagingProcessor = messagingProcessor;
        this.remotingChannelManager = new RemotingChannelManager(this, messagingProcessor.getProxyRelayService());
        RequestPipeline pipeline = this.createRequestPipeline(messagingProcessor);
        this.getTopicRouteActivity = new GetTopicRouteActivity(pipeline, messagingProcessor);
        this.clientManagerActivity = new ClientManagerActivity(pipeline, messagingProcessor, this.remotingChannelManager);
        this.consumerManagerActivity = new ConsumerManagerActivity(pipeline, messagingProcessor);
        this.sendMessageActivity = new SendMessageActivity(pipeline, messagingProcessor);
        this.recallMessageActivity = new RecallMessageActivity(pipeline, messagingProcessor);
        this.transactionActivity = new TransactionActivity(pipeline, messagingProcessor);
        this.pullMessageActivity = new PullMessageActivity(pipeline, messagingProcessor);
        this.popMessageActivity = new PopMessageActivity(pipeline, messagingProcessor);
        this.ackMessageActivity = new AckMessageActivity(pipeline, messagingProcessor);
        this.changeInvisibleTimeActivity = new ChangeInvisibleTimeActivity(pipeline, messagingProcessor);
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        NettyServerConfig defaultServerConfig = new NettyServerConfig();
        defaultServerConfig.setListenPort(config.getRemotingListenPort());
        TlsSystemConfig.tlsTestModeEnable = config.isTlsTestModeEnable();
        System.setProperty("tls.test.mode.enable", Boolean.toString(config.isTlsTestModeEnable()));
        TlsSystemConfig.tlsServerCertPath = config.getTlsCertPath();
        System.setProperty("tls.server.certPath", config.getTlsCertPath());
        TlsSystemConfig.tlsServerKeyPath = config.getTlsKeyPath();
        System.setProperty("tls.server.keyPath", config.getTlsKeyPath());
        this.clientHousekeepingService = new ClientHousekeepingService(this.clientManagerActivity);
        this.defaultRemotingServer = config.isEnableRemotingLocalProxyGrpc() ? new MultiProtocolRemotingServer(defaultServerConfig, this.clientHousekeepingService) : new NettyRemotingServer(defaultServerConfig, this.clientHousekeepingService);
        this.registerRemotingServer(this.defaultRemotingServer);
        this.sendMessageExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingSendMessageThreadPoolNums(), (int)config.getRemotingSendMessageThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"RemotingSendMessageThread", (int)config.getRemotingSendThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInSendQueue())});
        this.pullMessageExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingPullMessageThreadPoolNums(), (int)config.getRemotingPullMessageThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"RemotingPullMessageThread", (int)config.getRemotingPullThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInPullQueue())});
        this.updateOffsetExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingUpdateOffsetThreadPoolNums(), (int)config.getRemotingUpdateOffsetThreadPoolNums(), (long)1L, (TimeUnit)TimeUnit.MINUTES, (String)"RemotingUpdateOffsetThread", (int)config.getRemotingUpdateOffsetThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInUpdateOffsetQueue())});
        this.heartbeatExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingHeartbeatThreadPoolNums(), (int)config.getRemotingHeartbeatThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"RemotingHeartbeatThread", (int)config.getRemotingHeartbeatThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInHeartbeatQueue())});
        this.topicRouteExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingTopicRouteThreadPoolNums(), (int)config.getRemotingTopicRouteThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"RemotingTopicRouteThread", (int)config.getRemotingTopicRouteThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInTopicRouteQueue())});
        this.defaultExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getRemotingDefaultThreadPoolNums(), (int)config.getRemotingDefaultThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"RemotingDefaultThread", (int)config.getRemotingDefaultThreadPoolQueueCapacity(), (ThreadPoolStatusMonitor[])new ThreadPoolStatusMonitor[]{new ThreadPoolHeadSlowTimeMillsMonitor(config.getRemotingWaitTimeMillsInDefaultQueue())});
        this.timerExecutor = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryBuilder().setNameFormat("RemotingServerScheduler-%d").build());
        this.timerExecutor.scheduleAtFixedRate(this::cleanExpireRequest, 10L, 10L, TimeUnit.SECONDS);
    }

    protected void registerRemotingServer(RemotingServer remotingServer) {
        remotingServer.registerProcessor(10, (NettyRequestProcessor)this.sendMessageActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(310, (NettyRequestProcessor)this.sendMessageActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(320, (NettyRequestProcessor)this.sendMessageActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(36, (NettyRequestProcessor)this.sendMessageActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(37, (NettyRequestProcessor)this.transactionActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(370, (NettyRequestProcessor)this.recallMessageActivity, (ExecutorService)this.sendMessageExecutor);
        remotingServer.registerProcessor(34, (NettyRequestProcessor)this.clientManagerActivity, (ExecutorService)this.heartbeatExecutor);
        remotingServer.registerProcessor(35, (NettyRequestProcessor)this.clientManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(46, (NettyRequestProcessor)this.clientManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(11, (NettyRequestProcessor)this.pullMessageActivity, (ExecutorService)this.pullMessageExecutor);
        remotingServer.registerProcessor(361, (NettyRequestProcessor)this.pullMessageActivity, (ExecutorService)this.pullMessageExecutor);
        remotingServer.registerProcessor(200050, (NettyRequestProcessor)this.pullMessageActivity, (ExecutorService)this.pullMessageExecutor);
        remotingServer.registerProcessor(15, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.updateOffsetExecutor);
        remotingServer.registerProcessor(200051, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.updateOffsetExecutor);
        remotingServer.registerProcessor(200053, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.updateOffsetExecutor);
        remotingServer.registerProcessor(203, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.updateOffsetExecutor);
        remotingServer.registerProcessor(38, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(30, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(31, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(14, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(29, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(41, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(42, (NettyRequestProcessor)this.consumerManagerActivity, (ExecutorService)this.defaultExecutor);
        remotingServer.registerProcessor(105, (NettyRequestProcessor)this.getTopicRouteActivity, (ExecutorService)this.topicRouteExecutor);
    }

    public void shutdown() throws Exception {
        this.defaultRemotingServer.shutdown();
        this.remotingChannelManager.shutdown();
        this.sendMessageExecutor.shutdown();
        this.pullMessageExecutor.shutdown();
        this.heartbeatExecutor.shutdown();
        this.updateOffsetExecutor.shutdown();
        this.topicRouteExecutor.shutdown();
        this.defaultExecutor.shutdown();
    }

    public void start() throws Exception {
        this.remotingChannelManager.start();
        this.defaultRemotingServer.start();
    }

    @Override
    public CompletableFuture<RemotingCommand> invokeToClient(Channel channel, RemotingCommand request, long timeoutMillis) {
        final CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            this.defaultRemotingServer.invokeAsync(channel, request, timeoutMillis, new InvokeCallback(){

                public void operationComplete(ResponseFuture responseFuture) {
                }

                public void operationSucceed(RemotingCommand response) {
                    future.complete(response);
                }

                public void operationFail(Throwable throwable) {
                    future.completeExceptionally(throwable);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    protected RequestPipeline createRequestPipeline(MessagingProcessor messagingProcessor) {
        RequestPipeline pipeline = (ctx, request, context) -> {};
        AuthConfig authConfig = ConfigurationManager.getAuthConfig();
        if (authConfig != null) {
            pipeline = pipeline.pipe(new AuthorizationPipeline(authConfig, messagingProcessor)).pipe(new AuthenticationPipeline(authConfig, messagingProcessor));
        }
        return pipeline.pipe(new ContextInitPipeline());
    }

    protected long headSlowTimeMills(BlockingQueue<Runnable> q) {
        try {
            long slowTimeMills = 0L;
            Runnable peek = (Runnable)q.peek();
            if (peek != null) {
                RequestTask rt = this.castRunnable(peek);
                long l = slowTimeMills = rt == null ? 0L : System.currentTimeMillis() - rt.getCreateTimestamp();
            }
            if (slowTimeMills < 0L) {
                slowTimeMills = 0L;
            }
            return slowTimeMills;
        }
        catch (Exception e) {
            log.error("error when headSlowTimeMills.", (Throwable)e);
            return -1L;
        }
    }

    protected void cleanExpireRequest() {
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        this.cleanExpiredRequestInQueue(this.sendMessageExecutor, config.getRemotingWaitTimeMillsInSendQueue());
        this.cleanExpiredRequestInQueue(this.pullMessageExecutor, config.getRemotingWaitTimeMillsInPullQueue());
        this.cleanExpiredRequestInQueue(this.heartbeatExecutor, config.getRemotingWaitTimeMillsInHeartbeatQueue());
        this.cleanExpiredRequestInQueue(this.updateOffsetExecutor, config.getRemotingWaitTimeMillsInUpdateOffsetQueue());
        this.cleanExpiredRequestInQueue(this.topicRouteExecutor, config.getRemotingWaitTimeMillsInTopicRouteQueue());
        this.cleanExpiredRequestInQueue(this.defaultExecutor, config.getRemotingWaitTimeMillsInDefaultQueue());
    }

    protected void cleanExpiredRequestInQueue(ThreadPoolExecutor threadPoolExecutor, long maxWaitTimeMillsInQueue) {
        while (true) {
            try {
                long behind;
                RequestTask rt;
                Runnable runnable;
                BlockingQueue<Runnable> blockingQueue;
                while (!(blockingQueue = threadPoolExecutor.getQueue()).isEmpty() && null != (runnable = (Runnable)blockingQueue.peek()) && (rt = this.castRunnable(runnable)) != null && !rt.isStopRun() && (behind = System.currentTimeMillis() - rt.getCreateTimestamp()) >= maxWaitTimeMillsInQueue) {
                    if (!blockingQueue.remove(runnable)) continue;
                    rt.setStopRun(true);
                    rt.returnResponse(2, String.format("[TIMEOUT_CLEAN_QUEUE]broker busy, start flow control for a while, period in queue: %sms, size of queue: %d", behind, blockingQueue.size()));
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private RequestTask castRunnable(Runnable runnable) {
        try {
            if (runnable instanceof FutureTaskExt) {
                FutureTaskExt futureTaskExt = (FutureTaskExt)runnable;
                return (RequestTask)futureTaskExt.getRunnable();
            }
            return null;
        }
        catch (Throwable e) {
            log.error("castRunnable exception. class:{}", (Object)runnable.getClass().getName(), (Object)e);
            return null;
        }
    }

    protected class ThreadPoolHeadSlowTimeMillsMonitor
    implements ThreadPoolStatusMonitor {
        private final long maxWaitTimeMillsInQueue;

        public ThreadPoolHeadSlowTimeMillsMonitor(long maxWaitTimeMillsInQueue) {
            this.maxWaitTimeMillsInQueue = maxWaitTimeMillsInQueue;
        }

        public String describe() {
            return "headSlow";
        }

        public double value(ThreadPoolExecutor executor) {
            return RemotingProtocolServer.this.headSlowTimeMills(executor.getQueue());
        }

        public boolean needPrintJstack(ThreadPoolExecutor executor, double value) {
            return value > (double)this.maxWaitTimeMillsInQueue;
        }
    }
}

