/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.rocketmq.common.TopicAttributes;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.attribute.CleanupPolicy;

public class CleanupPolicyUtils {
    public static boolean isCompaction(Optional<TopicConfig> topicConfig) {
        return Objects.equals((Object)CleanupPolicy.COMPACTION, (Object)CleanupPolicyUtils.getDeletePolicy(topicConfig));
    }

    public static CleanupPolicy getDeletePolicy(Optional<TopicConfig> topicConfig) {
        if (!topicConfig.isPresent()) {
            return CleanupPolicy.valueOf(TopicAttributes.CLEANUP_POLICY_ATTRIBUTE.getDefaultValue());
        }
        String attributeName = TopicAttributes.CLEANUP_POLICY_ATTRIBUTE.getName();
        Map<String, String> attributes = topicConfig.get().getAttributes();
        if (attributes == null || attributes.size() == 0) {
            return CleanupPolicy.valueOf(TopicAttributes.CLEANUP_POLICY_ATTRIBUTE.getDefaultValue());
        }
        if (attributes.containsKey(attributeName)) {
            return CleanupPolicy.valueOf(attributes.get(attributeName));
        }
        return CleanupPolicy.valueOf(TopicAttributes.CLEANUP_POLICY_ATTRIBUTE.getDefaultValue());
    }
}

