/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;
import org.apache.rocketmq.tools.command.message.PrintMessageByQueueCommand;

public class ConsumeMessageCommand
implements SubCommand {
    private String topic = null;
    private long messageCount = 128L;
    private DefaultMQPullConsumer defaultMQPullConsumer;

    private static long timestampFormat(String value) {
        long timestamp;
        try {
            timestamp = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            timestamp = UtilAll.parseDate((String)value, (String)"yyyy-MM-dd#HH:mm:ss:SSS").getTime();
        }
        return timestamp;
    }

    @Override
    public String commandName() {
        return "consumeMessage";
    }

    @Override
    public String commandDesc() {
        return "Consume message.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "Topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("b", "brokerName", true, "Broker name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("i", "queueId", true, "Queue Id");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("o", "offset", true, "Queue offset");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("g", "consumerGroup", true, "Consumer group name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "beginTimestamp ", true, "Begin timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("e", "endTimestamp ", true, "End timestamp[currentTimeMillis|yyyy-MM-dd#HH:mm:ss:SSS]");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "MessageNumber", true, "Number of message to be consumed");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        if (this.defaultMQPullConsumer == null) {
            this.defaultMQPullConsumer = new DefaultMQPullConsumer("TOOLS_CONSUMER", rpcHook);
        }
        this.defaultMQPullConsumer.setInstanceName(Long.toString(System.currentTimeMillis()));
        long offset = 0L;
        long timeValueEnd = 0L;
        long timeValueBegin = 0L;
        String queueId = null;
        String brokerName = null;
        ConsumeType consumeType = ConsumeType.DEFAULT;
        try {
            String timestampStr;
            if (commandLine.hasOption('g')) {
                String consumerGroup = commandLine.getOptionValue('g').trim();
                this.defaultMQPullConsumer.setConsumerGroup(consumerGroup);
            }
            this.defaultMQPullConsumer.start();
            this.topic = commandLine.getOptionValue('t').trim();
            if (commandLine.hasOption('c')) {
                this.messageCount = Long.parseLong(commandLine.getOptionValue('c').trim());
                if (this.messageCount <= 0L) {
                    System.out.print("Please input a positive messageNumber!");
                    return;
                }
            }
            if (commandLine.hasOption('b')) {
                brokerName = commandLine.getOptionValue('b').trim();
            }
            if (commandLine.hasOption('i')) {
                if (!commandLine.hasOption('b')) {
                    System.out.print("Please set the brokerName before queueId!");
                    return;
                }
                queueId = commandLine.getOptionValue('i').trim();
                consumeType = ConsumeType.BYQUEUE;
            }
            if (commandLine.hasOption('o')) {
                if (consumeType != ConsumeType.BYQUEUE) {
                    System.out.print("Please set queueId before offset!");
                    return;
                }
                offset = Long.parseLong(commandLine.getOptionValue('o').trim());
                consumeType = ConsumeType.BYOFFSET;
            }
            long now = System.currentTimeMillis();
            if (commandLine.hasOption('s') && (timeValueBegin = ConsumeMessageCommand.timestampFormat(timestampStr = commandLine.getOptionValue('s').trim())) > now) {
                System.out.print("Please set the beginTimestamp before now!");
                return;
            }
            if (commandLine.hasOption('e')) {
                timestampStr = commandLine.getOptionValue('e').trim();
                timeValueEnd = ConsumeMessageCommand.timestampFormat(timestampStr);
                if (timeValueEnd > now) {
                    System.out.print("Please set the endTimestamp before now!");
                    return;
                }
                if (timeValueBegin > timeValueEnd) {
                    System.out.print("Please make sure that the beginTimestamp is less than or equal to the endTimestamp");
                    return;
                }
            }
            switch (consumeType) {
                case DEFAULT: {
                    this.executeDefault(timeValueBegin, timeValueEnd);
                    return;
                }
                case BYOFFSET: {
                    this.executeByCondition(brokerName, queueId, offset, timeValueBegin, timeValueEnd);
                    return;
                }
                case BYQUEUE: {
                    this.executeByCondition(brokerName, queueId, 0L, timeValueBegin, timeValueEnd);
                    return;
                }
                default: {
                    System.out.print("Unknown type of consume!");
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            this.defaultMQPullConsumer.shutdown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pullMessageByQueue(MessageQueue mq, long minOffset, long maxOffset) {
        long offset = minOffset;
        while (offset <= maxOffset) {
            PullResult pullResult = null;
            try {
                pullResult = this.defaultMQPullConsumer.pull(mq, "*", offset, (int)(maxOffset - offset + 1L));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (pullResult == null) continue;
            offset = pullResult.getNextBeginOffset();
            switch (pullResult.getPullStatus()) {
                case FOUND: {
                    System.out.print("Consume ok\n");
                    PrintMessageByQueueCommand.printMessage(pullResult.getMsgFoundList(), "UTF-8", true, true);
                    break;
                }
                case NO_MATCHED_MSG: {
                    System.out.printf("%s no matched msg. status=%s, offset=%s\n", mq, pullResult.getPullStatus(), offset);
                    break;
                }
                case NO_NEW_MSG: 
                case OFFSET_ILLEGAL: {
                    System.out.printf("%s print msg finished. status=%s, offset=%s\n", mq, pullResult.getPullStatus(), offset);
                    return;
                }
            }
        }
    }

    private void executeDefault(long timeValueBegin, long timeValueEnd) {
        try {
            Set mqs = this.defaultMQPullConsumer.fetchSubscribeMessageQueues(this.topic);
            long countLeft = this.messageCount;
            for (MessageQueue mq : mqs) {
                if (countLeft == 0L) {
                    return;
                }
                long minOffset = this.defaultMQPullConsumer.minOffset(mq);
                long maxOffset = this.defaultMQPullConsumer.maxOffset(mq);
                if (timeValueBegin > 0L) {
                    minOffset = this.defaultMQPullConsumer.searchOffset(mq, timeValueBegin);
                }
                if (timeValueEnd > 0L) {
                    maxOffset = this.defaultMQPullConsumer.searchOffset(mq, timeValueEnd);
                }
                if (maxOffset - minOffset > countLeft) {
                    System.out.printf("The older %d message of the %d queue will be provided\n", countLeft, mq.getQueueId());
                    maxOffset = minOffset + countLeft - 1L;
                    countLeft = 0L;
                } else {
                    countLeft = countLeft - (maxOffset - minOffset) - 1L;
                }
                this.pullMessageByQueue(mq, minOffset, maxOffset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeByCondition(String brokerName, String queueId, long offset, long timeValueBegin, long timeValueEnd) {
        MessageQueue mq = new MessageQueue(this.topic, brokerName, Integer.parseInt(queueId));
        try {
            long minOffset = this.defaultMQPullConsumer.minOffset(mq);
            long maxOffset = this.defaultMQPullConsumer.maxOffset(mq);
            if (timeValueBegin > 0L) {
                minOffset = this.defaultMQPullConsumer.searchOffset(mq, timeValueBegin);
            }
            if (timeValueEnd > 0L) {
                maxOffset = this.defaultMQPullConsumer.searchOffset(mq, timeValueEnd);
            }
            if (offset > maxOffset) {
                System.out.printf("%s no matched msg, offset=%s\n", mq, offset);
                return;
            }
            long l = minOffset = minOffset > offset ? minOffset : offset;
            if (maxOffset - minOffset > this.messageCount) {
                System.out.printf("The oldler %d message will be provided\n", this.messageCount);
                maxOffset = minOffset + this.messageCount - 1L;
            }
            this.pullMessageByQueue(mq, minOffset, maxOffset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum ConsumeType {
        DEFAULT,
        BYQUEUE,
        BYOFFSET;

    }
}

