/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.export;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.ClusterInfo;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ExportPopRecordCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "exportPopRecord";
    }

    @Override
    public String commandDesc() {
        return "Export pop consumer record";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterName", true, "choose one cluster to export");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "brokerAddr", true, "choose one broker to export");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("d", "dryRun", true, "no actual changes will be made");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt adminExt = new DefaultMQAdminExt(rpcHook);
        adminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            boolean dryRun;
            adminExt.start();
            boolean bl = dryRun = commandLine.hasOption('d') && Boolean.FALSE.toString().equalsIgnoreCase(commandLine.getOptionValue('d'));
            if (commandLine.hasOption('b')) {
                String brokerAddr = commandLine.getOptionValue('b').trim();
                String brokerName2 = adminExt.getBrokerConfig(brokerAddr).getProperty("brokerName");
                this.export(adminExt, brokerAddr, brokerName2, dryRun);
            } else if (commandLine.hasOption('c')) {
                Set brokerNameSet;
                String clusterName = commandLine.getOptionValue('c').trim();
                ClusterInfo clusterInfo = adminExt.examineBrokerClusterInfo();
                if (clusterInfo != null && (brokerNameSet = (Set)clusterInfo.getClusterAddrTable().get(clusterName)) != null) {
                    brokerNameSet.forEach(brokerName -> {
                        BrokerData brokerData = (BrokerData)clusterInfo.getBrokerAddrTable().get(brokerName);
                        if (brokerData != null) {
                            brokerData.getBrokerAddrs().forEach((brokerId, brokerAddr) -> this.export(adminExt, (String)brokerAddr, (String)brokerName, dryRun));
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            adminExt.shutdown();
        }
    }

    private void export(DefaultMQAdminExt adminExt, String brokerAddr, String brokerName, boolean dryRun) {
        try {
            if (!dryRun) {
                adminExt.exportPopRecords(brokerAddr, TimeUnit.SECONDS.toMillis(30L));
            }
            System.out.printf("Export broker records, brokerName=%s, brokerAddr=%s, dryRun=%s%n", brokerName, brokerAddr, dryRun);
        }
        catch (Exception e) {
            System.out.printf("Export broker records error, brokerName=%s, brokerAddr=%s, dryRun=%s%n%s", brokerName, brokerAddr, dryRun, e);
        }
    }
}

