/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.export;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.ConfigRocksDBStorage;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;
import org.rocksdb.RocksIterator;

public class ExportMetadataInRocksDBCommand
implements SubCommand {
    private static final String TOPICS_JSON_CONFIG = "topics";
    private static final String SUBSCRIPTION_GROUP_JSON_CONFIG = "subscriptionGroups";

    @Override
    public String commandName() {
        return "exportMetadataInRocksDB";
    }

    @Override
    public String commandDesc() {
        return "export RocksDB kv config (topics/subscriptionGroups). Recommend to use [mqadmin rocksDBConfigToJson]";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option pathOption = new Option("p", "path", true, "Absolute path for the metadata directory");
        pathOption.setRequired(true);
        options.addOption(pathOption);
        Option configTypeOption = new Option("t", "configType", true, "Name of kv config, e.g. topics/subscriptionGroups");
        configTypeOption.setRequired(true);
        options.addOption(configTypeOption);
        Option jsonEnableOption = new Option("j", "jsonEnable", true, "Json format enable, Default: false");
        jsonEnableOption.setRequired(false);
        options.addOption(jsonEnableOption);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        ConfigRocksDBStorage kvStore;
        String path = commandLine.getOptionValue("path").trim();
        if (StringUtils.isEmpty((CharSequence)path) || !UtilAll.isPathExists((String)path)) {
            System.out.print("RocksDB path is invalid.\n");
            return;
        }
        String configType = commandLine.getOptionValue("configType").trim();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + configType;
        boolean jsonEnable = false;
        if (commandLine.hasOption("jsonEnable")) {
            jsonEnable = Boolean.parseBoolean(commandLine.getOptionValue("jsonEnable").trim());
        }
        if (!(kvStore = new ConfigRocksDBStorage(path, true)).start()) {
            System.out.printf("RocksDB load error, path=%s\n", path);
            return;
        }
        try {
            if (TOPICS_JSON_CONFIG.equalsIgnoreCase(configType) || SUBSCRIPTION_GROUP_JSON_CONFIG.equalsIgnoreCase(configType)) {
                ExportMetadataInRocksDBCommand.handleExportMetadata(kvStore, configType, jsonEnable);
            } else {
                System.out.printf("Invalid config type=%s, Options: topics,subscriptionGroups\n", configType);
            }
        }
        finally {
            kvStore.shutdown();
        }
    }

    private static void handleExportMetadata(ConfigRocksDBStorage kvStore, String configType, boolean jsonEnable) {
        if (jsonEnable) {
            HashMap<String, JSONObject> jsonConfig = new HashMap<String, JSONObject>();
            HashMap configTable = new HashMap();
            ExportMetadataInRocksDBCommand.iterateKvStore(kvStore, (key, value) -> {
                String configKey = new String((byte[])key, DataConverter.CHARSET_UTF8);
                String configValue = new String((byte[])value, DataConverter.CHARSET_UTF8);
                JSONObject jsonObject = JSONObject.parseObject((String)configValue);
                configTable.put(configKey, jsonObject);
            });
            jsonConfig.put(configType.equalsIgnoreCase(TOPICS_JSON_CONFIG) ? "topicConfigTable" : "subscriptionGroupTable", (JSONObject)JSONObject.toJSON(configTable));
            String jsonConfigStr = JSONObject.toJSONString(jsonConfig, (boolean)true);
            System.out.print(jsonConfigStr + "\n");
        } else {
            AtomicLong count = new AtomicLong(0L);
            ExportMetadataInRocksDBCommand.iterateKvStore(kvStore, (key, value) -> {
                String configKey = new String((byte[])key, DataConverter.CHARSET_UTF8);
                String configValue = new String((byte[])value, DataConverter.CHARSET_UTF8);
                System.out.printf("%d, Key: %s, Value: %s%n", count.incrementAndGet(), configKey, configValue);
            });
        }
    }

    private static void iterateKvStore(ConfigRocksDBStorage kvStore, BiConsumer<byte[], byte[]> biConsumer) {
        try (RocksIterator iterator = kvStore.iterator();){
            iterator.seekToFirst();
            iterator.seekToFirst();
            while (iterator.isValid()) {
                biConsumer.accept(iterator.key(), iterator.value());
                iterator.next();
            }
        }
    }
}

