/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.auth;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.body.UserInfo;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class CopyUsersSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "copyUser";
    }

    @Override
    public String commandDesc() {
        return "Copy user to cluster.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("f", "fromBroker", true, "the source broker that the users copy from");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "toBroker", true, "the target broker that the users copy to");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("u", "usernames", true, "the username list of user to copy.");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption("f") && commandLine.hasOption("t")) {
                String sourceBroker = StringUtils.trim((String)commandLine.getOptionValue("f"));
                String targetBroker = StringUtils.trim((String)commandLine.getOptionValue("t"));
                String usernames = StringUtils.trim((String)commandLine.getOptionValue('u'));
                defaultMQAdminExt.start();
                List<Object> userInfos = new ArrayList();
                if (StringUtils.isNotBlank((CharSequence)usernames)) {
                    for (String username : StringUtils.split((String)usernames, (String)",")) {
                        UserInfo userInfo = defaultMQAdminExt.getUser(sourceBroker, username);
                        if (userInfo == null) continue;
                        userInfos.add(userInfo);
                    }
                } else {
                    userInfos = defaultMQAdminExt.listUser(sourceBroker, null);
                }
                if (CollectionUtils.isEmpty(userInfos)) {
                    return;
                }
                for (UserInfo userInfo : userInfos) {
                    if (defaultMQAdminExt.getUser(targetBroker, userInfo.getUsername()) == null) {
                        defaultMQAdminExt.createUser(targetBroker, userInfo);
                    } else {
                        defaultMQAdminExt.updateUser(targetBroker, userInfo);
                    }
                    System.out.printf("copy user of %s from %s to %s success.%n", userInfo.getUsername(), sourceBroker, targetBroker);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

