/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.auth.authorization.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.rocketmq.auth.authorization.enums.Decision;
import org.apache.rocketmq.auth.authorization.model.Environment;
import org.apache.rocketmq.auth.authorization.model.Resource;
import org.apache.rocketmq.common.action.Action;

public class PolicyEntry {
    private Resource resource;
    private List<Action> actions;
    private Environment environment;
    private Decision decision;

    public static PolicyEntry of(Resource resource, List<Action> actions, Environment environment, Decision decision) {
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setResource(resource);
        policyEntry.setActions(actions);
        policyEntry.setEnvironment(environment);
        policyEntry.setDecision(decision);
        return policyEntry;
    }

    public void updateEntry(List<Action> actions, Environment environment, Decision decision) {
        this.setActions(actions);
        this.setEnvironment(environment);
        this.setDecision(decision);
    }

    public boolean isMatchResource(Resource resource) {
        return this.resource.isMatch(resource);
    }

    public boolean isMatchAction(List<Action> actions) {
        if (CollectionUtils.isEmpty(this.actions)) {
            return false;
        }
        if (actions.contains(Action.ANY)) {
            return true;
        }
        return actions.stream().anyMatch(action -> this.actions.contains(action) || this.actions.contains(Action.ALL));
    }

    public boolean isMatchEnvironment(Environment environment) {
        if (this.environment == null) {
            return true;
        }
        return this.environment.isMatch(environment);
    }

    public String toResourceStr() {
        if (this.resource == null) {
            return null;
        }
        return this.resource.getResourceKey();
    }

    public List<String> toActionsStr() {
        if (CollectionUtils.isEmpty(this.actions)) {
            return null;
        }
        return this.actions.stream().map(Action::getName).collect(Collectors.toList());
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public void setDecision(Decision decision) {
        this.decision = decision;
    }
}

