/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CMAPTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeFont {
    private final Log log = LogFactory.getLog(TrueTypeFont.class);
    private float version;
    private int numberOfGlyphs = -1;
    private int unitsPerEm = -1;
    private int[] advanceWidths = null;
    private Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private TTFDataStream data;

    TrueTypeFont(TTFDataStream fontData) {
        this.data = fontData;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public void addTable(TTFTable table) {
        this.tables.put(table.getTag(), table);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public NamingTable getNaming() {
        NamingTable naming = (NamingTable)this.tables.get("name");
        if (naming != null && !naming.getInitialized()) {
            this.initializeTable(naming);
        }
        return naming;
    }

    public PostScriptTable getPostScript() {
        PostScriptTable postscript = (PostScriptTable)this.tables.get("post");
        if (postscript != null && !postscript.getInitialized()) {
            this.initializeTable(postscript);
        }
        return postscript;
    }

    public OS2WindowsMetricsTable getOS2Windows() {
        OS2WindowsMetricsTable os2WindowsMetrics = (OS2WindowsMetricsTable)this.tables.get("OS/2");
        if (os2WindowsMetrics != null && !os2WindowsMetrics.getInitialized()) {
            this.initializeTable(os2WindowsMetrics);
        }
        return os2WindowsMetrics;
    }

    public MaximumProfileTable getMaximumProfile() {
        MaximumProfileTable maximumProfile = (MaximumProfileTable)this.tables.get("maxp");
        if (maximumProfile != null && !maximumProfile.getInitialized()) {
            this.initializeTable(maximumProfile);
        }
        return maximumProfile;
    }

    public HeaderTable getHeader() {
        HeaderTable header = (HeaderTable)this.tables.get("head");
        if (header != null && !header.getInitialized()) {
            this.initializeTable(header);
        }
        return header;
    }

    public HorizontalHeaderTable getHorizontalHeader() {
        HorizontalHeaderTable horizontalHeader = (HorizontalHeaderTable)this.tables.get("hhea");
        if (horizontalHeader != null && !horizontalHeader.getInitialized()) {
            this.initializeTable(horizontalHeader);
        }
        return horizontalHeader;
    }

    public HorizontalMetricsTable getHorizontalMetrics() {
        HorizontalMetricsTable horizontalMetrics = (HorizontalMetricsTable)this.tables.get("hmtx");
        if (horizontalMetrics != null && !horizontalMetrics.getInitialized()) {
            this.initializeTable(horizontalMetrics);
        }
        return horizontalMetrics;
    }

    public IndexToLocationTable getIndexToLocation() {
        IndexToLocationTable indexToLocation = (IndexToLocationTable)this.tables.get("loca");
        if (indexToLocation != null && !indexToLocation.getInitialized()) {
            this.initializeTable(indexToLocation);
        }
        return indexToLocation;
    }

    public GlyphTable getGlyph() {
        GlyphTable glyph = (GlyphTable)this.tables.get("glyf");
        if (glyph != null && !glyph.getInitialized()) {
            this.initializeTable(glyph);
        }
        return glyph;
    }

    public CMAPTable getCMAP() {
        CMAPTable cmap = (CMAPTable)this.tables.get("cmap");
        if (cmap != null && !cmap.getInitialized()) {
            this.initializeTable(cmap);
        }
        return cmap;
    }

    public InputStream getOriginalData() throws IOException {
        return this.data.getOriginalData();
    }

    public void initializeTable(TTFTable table) {
        try {
            long currentPosition = this.data.getCurrentPosition();
            this.data.seek(table.getOffset());
            table.initData(this, this.data);
            this.data.seek(currentPosition);
        }
        catch (IOException exception) {
            this.log.error("An error occured when reading table " + table.getTag(), exception);
        }
    }

    public int getNumberOfGlyphs() {
        if (this.numberOfGlyphs == -1) {
            MaximumProfileTable maximumProfile = this.getMaximumProfile();
            this.numberOfGlyphs = maximumProfile != null ? maximumProfile.getNumGlyphs() : 0;
        }
        return this.numberOfGlyphs;
    }

    public int getUnitsPerEm() {
        if (this.unitsPerEm == -1) {
            HeaderTable header = this.getHeader();
            this.unitsPerEm = header != null ? header.getUnitsPerEm() : 0;
        }
        return this.unitsPerEm;
    }

    public int getAdvanceWidth(int code) {
        if (this.advanceWidths == null) {
            HorizontalMetricsTable hmtx = this.getHorizontalMetrics();
            this.advanceWidths = hmtx != null ? hmtx.getAdvanceWidth() : new int[]{250};
        }
        if (this.advanceWidths.length > code) {
            return this.advanceWidths[code];
        }
        return this.advanceWidths[this.advanceWidths.length - 1];
    }
}

