/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.servicedocument.Accept;
import org.apache.olingo.odata2.api.servicedocument.Categories;
import org.apache.olingo.odata2.api.servicedocument.Category;
import org.apache.olingo.odata2.api.servicedocument.Collection;
import org.apache.olingo.odata2.api.servicedocument.ExtensionAttribute;
import org.apache.olingo.odata2.api.servicedocument.ExtensionElement;
import org.apache.olingo.odata2.api.servicedocument.Fixed;
import org.apache.olingo.odata2.api.servicedocument.Workspace;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.servicedocument.AcceptImpl;
import org.apache.olingo.odata2.core.servicedocument.AtomInfoImpl;
import org.apache.olingo.odata2.core.servicedocument.CategoriesImpl;
import org.apache.olingo.odata2.core.servicedocument.CategoryImpl;
import org.apache.olingo.odata2.core.servicedocument.CollectionImpl;
import org.apache.olingo.odata2.core.servicedocument.CommonAttributesImpl;
import org.apache.olingo.odata2.core.servicedocument.ExtensionAttributeImpl;
import org.apache.olingo.odata2.core.servicedocument.ExtensionElementImpl;
import org.apache.olingo.odata2.core.servicedocument.ServiceDocumentImpl;
import org.apache.olingo.odata2.core.servicedocument.TitleImpl;
import org.apache.olingo.odata2.core.servicedocument.WorkspaceImpl;

public class AtomServiceDocumentConsumer {
    private String currentHandledStartTagName;
    private static final String DEFAULT_PREFIX = "";

    public ServiceDocumentImpl readServiceDokument(XMLStreamReader reader) throws EntityProviderException {
        AtomInfoImpl atomInfo = new AtomInfoImpl();
        ServiceDocumentImpl serviceDocument = new ServiceDocumentImpl();
        ArrayList<Workspace> workspaces = new ArrayList<Workspace>();
        ArrayList<ExtensionElement> extElements = new ArrayList<ExtensionElement>();
        CommonAttributesImpl attributes = new CommonAttributesImpl();
        try {
            while (!(!reader.hasNext() || reader.isEndElement() && "http://www.w3.org/2007/app".equals(reader.getNamespaceURI()) && "service".equals(reader.getLocalName()))) {
                reader.next();
                if (!reader.isStartElement()) continue;
                this.currentHandledStartTagName = reader.getLocalName();
                if ("service".equals(this.currentHandledStartTagName)) {
                    attributes = this.parseCommonAttribute(reader);
                    continue;
                }
                if ("workspace".equals(this.currentHandledStartTagName)) {
                    workspaces.add(this.parseWorkspace(reader));
                    continue;
                }
                ExtensionElementImpl extElement = this.parseExtensionElement(reader);
                if (extElement == null) continue;
                extElements.add(extElement);
            }
            if (workspaces.isEmpty()) {
                throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Service element must contain at least one workspace element"}));
            }
            reader.close();
            atomInfo.setWorkspaces(workspaces).setCommonAttributes(attributes).setExtesionElements(extElements);
            serviceDocument.setAtomInfo(atomInfo);
            serviceDocument.setEntitySetsInfo(atomInfo.getEntitySetsInfo());
            return serviceDocument;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private CommonAttributesImpl parseCommonAttribute(XMLStreamReader reader) {
        CommonAttributesImpl attribute = new CommonAttributesImpl();
        ArrayList<ExtensionAttribute> extAttributes = new ArrayList<ExtensionAttribute>();
        attribute.setBase(reader.getAttributeValue(null, "base"));
        attribute.setLang(reader.getAttributeValue(null, "lang"));
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if ("base".equals(reader.getAttributeLocalName(i)) && "xml".equals(reader.getAttributePrefix(i)) || "lang".equals(reader.getAttributeLocalName(i)) && "xml".equals(reader.getAttributePrefix(i)) || "local".equals(reader.getAttributeNamespace(i)) || DEFAULT_PREFIX.equals(reader.getAttributePrefix(i))) continue;
            extAttributes.add(new ExtensionAttributeImpl().setName(reader.getAttributeLocalName(i)).setNamespace(reader.getAttributeNamespace(i)).setPrefix(reader.getAttributePrefix(i)).setText(reader.getAttributeValue(i)));
        }
        return attribute.setAttributes(extAttributes);
    }

    private WorkspaceImpl parseWorkspace(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, "http://www.w3.org/2007/app", "workspace");
        TitleImpl title = null;
        ArrayList<Collection> collections = new ArrayList<Collection>();
        ArrayList<ExtensionElement> extElements = new ArrayList<ExtensionElement>();
        CommonAttributesImpl attributes = this.parseCommonAttribute(reader);
        while (!(!reader.hasNext() || reader.isEndElement() && "http://www.w3.org/2007/app".equals(reader.getNamespaceURI()) && "workspace".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.currentHandledStartTagName = reader.getLocalName();
            if ("collection".equals(this.currentHandledStartTagName)) {
                collections.add(this.parseCollection(reader));
                continue;
            }
            if ("title".equals(this.currentHandledStartTagName)) {
                title = this.parseTitle(reader);
                continue;
            }
            extElements.add(this.parseExtensionSansTitleElement(reader));
        }
        if (title == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Missing element title for workspace"}));
        }
        return new WorkspaceImpl().setTitle(title).setCollections(collections).setAttributes(attributes).setExtesionElements(extElements);
    }

    private CollectionImpl parseCollection(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, "http://www.w3.org/2007/app", "collection");
        TitleImpl title = null;
        String resourceIdentifier = reader.getAttributeValue(null, "href");
        CommonAttributesImpl attributes = this.parseCommonAttribute(reader);
        ArrayList<ExtensionElement> extElements = new ArrayList<ExtensionElement>();
        ArrayList<Accept> acceptList = new ArrayList<Accept>();
        ArrayList<Categories> categories = new ArrayList<Categories>();
        if (resourceIdentifier == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"href"}));
        }
        while (!(!reader.hasNext() || reader.isEndElement() && "http://www.w3.org/2007/app".equals(reader.getNamespaceURI()) && "collection".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.currentHandledStartTagName = reader.getLocalName();
            if ("title".equals(this.currentHandledStartTagName)) {
                title = this.parseTitle(reader);
                continue;
            }
            if ("accept".equals(this.currentHandledStartTagName)) {
                acceptList.add(this.parseAccept(reader));
                continue;
            }
            if ("categories".equals(this.currentHandledStartTagName)) {
                categories.add(this.parseCategories(reader));
                continue;
            }
            extElements.add(this.parseExtensionSansTitleElement(reader));
        }
        return new CollectionImpl().setHref(resourceIdentifier).setTitle(title).setCommonAttributes(attributes).setExtesionElements(extElements).setAcceptElements(acceptList).setCategories(categories);
    }

    private TitleImpl parseTitle(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "title");
        String text = reader.getElementText();
        reader.require(2, "http://www.w3.org/2005/Atom", "title");
        return new TitleImpl().setText(text);
    }

    private AcceptImpl parseAccept(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, "http://www.w3.org/2007/app", "accept");
        CommonAttributesImpl commonAttributes = this.parseCommonAttribute(reader);
        String text = reader.getElementText();
        reader.require(2, "http://www.w3.org/2007/app", "accept");
        return new AcceptImpl().setCommonAttributes(commonAttributes).setText(text);
    }

    private CategoriesImpl parseCategories(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, "http://www.w3.org/2007/app", "categories");
        CategoriesImpl categories = new CategoriesImpl();
        String href = reader.getAttributeValue(null, "href");
        String fixed = reader.getAttributeValue(null, "fixed");
        categories.setScheme(reader.getAttributeValue(null, "scheme"));
        categories.setHref(href);
        if (href == null) {
            for (int i = 0; i < Fixed.values().length; ++i) {
                if (!Fixed.values()[i].name().equalsIgnoreCase(fixed)) continue;
                categories.setFixed(Fixed.values()[i]);
            }
            if (categories.getFixed() == null) {
                categories.setFixed(Fixed.NO);
            }
            ArrayList<Category> categoriesList = new ArrayList<Category>();
            while (!(!reader.hasNext() || reader.isEndElement() && "http://www.w3.org/2007/app".equals(reader.getNamespaceURI()) && "categories".equals(reader.getLocalName()))) {
                reader.next();
                if (!reader.isStartElement()) continue;
                this.currentHandledStartTagName = reader.getLocalName();
                if (!"category".equals(this.currentHandledStartTagName)) continue;
                categoriesList.add(this.parseCategory(reader));
            }
            categories.setCategoryList(categoriesList);
        }
        if (href != null && fixed != null && categories.getScheme() != null || href == null && fixed == null && categories.getScheme() == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"for the element categories"}));
        }
        return categories;
    }

    private CategoryImpl parseCategory(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, "http://www.w3.org/2005/Atom", "category");
        CategoryImpl category = new CategoryImpl();
        category.setScheme(reader.getAttributeValue(null, "scheme"));
        category.setTerm(reader.getAttributeValue(null, "term"));
        category.setLabel(reader.getAttributeValue(null, "label"));
        CommonAttributesImpl attributes = this.parseCommonAttribute(reader);
        return category.setCommonAttributes(attributes);
    }

    private ExtensionElementImpl parseExtensionSansTitleElement(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        ExtensionElementImpl extElement = new ExtensionElementImpl();
        if (!("http://www.w3.org/2007/app".equals(reader.getNamespaceURI()) || "title".equals(reader.getLocalName()) && "http://www.w3.org/2005/Atom".equals(reader.getNamespaceURI()))) {
            extElement = this.parseElement(reader);
        }
        return extElement;
    }

    private ExtensionElementImpl parseExtensionElement(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        ExtensionElementImpl extElement = null;
        if (!"http://www.w3.org/2007/app".equals(reader.getNamespaceURI())) {
            extElement = this.parseElement(reader);
        }
        return extElement;
    }

    private ExtensionElementImpl parseElement(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        ArrayList<ExtensionElement> extensionElements = new ArrayList<ExtensionElement>();
        ExtensionElementImpl extElement = new ExtensionElementImpl().setName(reader.getLocalName()).setNamespace(reader.getNamespaceURI()).setPrefix(reader.getPrefix());
        extElement.setAttributes(this.parseAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && extElement.getName() != null && extElement.getName().equals(reader.getLocalName()))) {
            reader.next();
            if (reader.isStartElement()) {
                extensionElements.add(this.parseExtensionElement(reader));
                continue;
            }
            if (!reader.isCharacters()) continue;
            Object extElementText = DEFAULT_PREFIX;
            do {
                extElementText = (String)extElementText + reader.getText();
                reader.next();
            } while (reader.isCharacters());
            extElement.setText((String)extElementText);
        }
        extElement.setElements(extensionElements);
        if (extElement.getText() == null && extElement.getAttributes().isEmpty() && extElement.getElements().isEmpty()) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Invalid extension element"}));
        }
        return extElement;
    }

    private List<ExtensionAttribute> parseAttribute(XMLStreamReader reader) {
        ArrayList<ExtensionAttribute> extAttributes = new ArrayList<ExtensionAttribute>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            extAttributes.add(new ExtensionAttributeImpl().setName(reader.getAttributeLocalName(i)).setNamespace(reader.getAttributeNamespace(i)).setPrefix(reader.getAttributePrefix(i)).setText(reader.getAttributeValue(i)));
        }
        return extAttributes;
    }

    public ServiceDocumentImpl parseXml(InputStream in) throws EntityProviderException {
        return this.readServiceDokument(XmlHelper.createStreamReader(in));
    }
}

