/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;
import org.apache.olingo.odata2.core.uri.expression.TokenizerExpectError;

public class ExpressionParserInternalError
extends ODataMessageException {
    static final long serialVersionUID = 77L;
    public static final MessageReference ERROR_PARSING_METHOD = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"ERROR_PARSING_METHOD");
    public static final MessageReference ERROR_PARSING_PARENTHESIS = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"ERROR_PARSING_PARENTHESIS");
    public static final MessageReference ERROR_ACCESSING_EDM = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"ERROR_ACCESSING_EDM");
    public static final MessageReference INVALID_TYPE_COUNT = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"INVALID_TYPE_COUNT");
    public static final MessageReference INVALID_TOKEN_AT = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"INVALID_TOKEN_AT");
    public static final MessageReference INVALID_TOKENKIND_AT = ExpressionParserInternalError.createMessageReference(ExpressionParserInternalError.class, (String)"INVALID_TOKENKIND_AT");
    CommonExpression parenthesisExpression = null;

    public ExpressionParserInternalError(MessageReference messageReference) {
        super(messageReference);
    }

    public ExpressionParserInternalError(MessageReference messageReference, Throwable cause) {
        super(messageReference, cause);
    }

    public ExpressionParserInternalError(MessageReference messageReference, TokenizerExpectError cause) {
        super(messageReference, (Throwable)((Object)cause));
    }

    public ExpressionParserInternalError(MessageReference messageReference, EdmException cause) {
        super(messageReference, (Throwable)cause);
    }

    public ExpressionParserInternalError setExpression(CommonExpression parenthesisExpression) {
        this.parenthesisExpression = parenthesisExpression;
        return this;
    }

    public static ExpressionParserInternalError createERROR_PARSING_METHOD(TokenizerExpectError cause) {
        return new ExpressionParserInternalError(ERROR_PARSING_METHOD, cause);
    }

    public static ExpressionParserInternalError createERROR_PARSING_PARENTHESIS(TokenizerExpectError cause) {
        return new ExpressionParserInternalError(ERROR_PARSING_PARENTHESIS, cause);
    }

    public static ExpressionParserInternalError createERROR_PARSING_PARENTHESIS(CommonExpression parenthesisExpression, TokenizerExpectError cause) {
        return new ExpressionParserInternalError(ERROR_PARSING_PARENTHESIS, cause).setExpression(parenthesisExpression);
    }

    public static ExpressionParserInternalError createERROR_ACCESSING_EDM(EdmException cause) {
        return new ExpressionParserInternalError(ERROR_ACCESSING_EDM, cause);
    }

    public static ExpressionParserInternalError createCOMMON() {
        return new ExpressionParserInternalError(COMMON);
    }

    public static ExpressionParserInternalError createCOMMON(Throwable e) {
        return new ExpressionParserInternalError(COMMON, e);
    }

    public static ExpressionParserInternalError createINVALID_TYPE_COUNT() {
        return new ExpressionParserInternalError(INVALID_TYPE_COUNT);
    }

    public static ExpressionParserInternalError createERROR_ACCESSING_EDM() {
        return new ExpressionParserInternalError(ERROR_ACCESSING_EDM);
    }

    public static ExpressionParserInternalError createINVALID_TOKEN_AT(String expectedToken, Token actualToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedToken});
        msgRef.addContent(new Object[]{actualToken.getUriLiteral()});
        msgRef.addContent(new Object[]{actualToken.getPosition()});
        return new ExpressionParserInternalError(msgRef);
    }

    public static ExpressionParserInternalError createINVALID_TOKENKIND_AT(TokenKind expectedTokenKind, Token actualToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedTokenKind.toString()});
        msgRef.addContent(new Object[]{actualToken.getKind().toString()});
        msgRef.addContent(new Object[]{actualToken.getUriLiteral()});
        msgRef.addContent(new Object[]{actualToken.getPosition()});
        return new ExpressionParserInternalError(msgRef);
    }

    public static ExpressionParserInternalError createNO_TOKEN_AVAILABLE(String expectedToken) {
        MessageReference msgRef = INVALID_TOKEN_AT.create();
        msgRef.addContent(new Object[]{expectedToken});
        return new ExpressionParserInternalError(msgRef);
    }
}

