/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;

public class MessageEncryptionMechanism {
    private final EncryptedDataPacketType mode;
    private final int symmetricKeyAlgorithm;
    private final int aeadAlgorithm;

    private MessageEncryptionMechanism(EncryptedDataPacketType encryptedDataPacketType, int n, int n2) {
        this.mode = encryptedDataPacketType;
        this.symmetricKeyAlgorithm = n;
        this.aeadAlgorithm = n2;
    }

    public EncryptedDataPacketType getMode() {
        return this.mode;
    }

    public int getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public static MessageEncryptionMechanism unencrypted() {
        int n = 0;
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv1, 0, n);
    }

    public static MessageEncryptionMechanism integrityProtected(int n) {
        int n2 = 0;
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv1, n, n2);
    }

    public static MessageEncryptionMechanism librePgp(int n) {
        return new MessageEncryptionMechanism(EncryptedDataPacketType.LIBREPGP_OED, n, 2);
    }

    public static MessageEncryptionMechanism aead(int n, int n2) {
        return new MessageEncryptionMechanism(EncryptedDataPacketType.SEIPDv2, n, n2);
    }

    public static MessageEncryptionMechanism aead(PreferredAEADCiphersuites.Combination combination) {
        return MessageEncryptionMechanism.aead(combination.getSymmetricAlgorithm(), combination.getAeadAlgorithm());
    }

    public boolean isEncrypted() {
        return this.symmetricKeyAlgorithm != 0;
    }

    public int hashCode() {
        return this.mode.hashCode() + 13 * this.symmetricKeyAlgorithm + 17 * this.aeadAlgorithm;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageEncryptionMechanism)) {
            return false;
        }
        MessageEncryptionMechanism messageEncryptionMechanism = (MessageEncryptionMechanism)object;
        return this.getMode() == messageEncryptionMechanism.getMode() && this.getSymmetricKeyAlgorithm() == messageEncryptionMechanism.getSymmetricKeyAlgorithm() && this.getAeadAlgorithm() == messageEncryptionMechanism.getAeadAlgorithm();
    }
}

