/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.u2f;

import java.security.PublicKey;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SkED25519PublicKey
implements SecurityKeyPublicKey<PublicKey> {
    public static final String ALGORITHM = "ED25519-SK";
    private static final long serialVersionUID = -3947776805731312115L;
    private final String appName;
    private final boolean noTouchRequired;
    private final boolean verifyRequired;
    private final PublicKey delegatePublicKey;

    @Deprecated
    public SkED25519PublicKey(String appName, boolean noTouchRequired, PublicKey delegatePublicKey) {
        this(appName, noTouchRequired, false, delegatePublicKey);
    }

    public SkED25519PublicKey(String appName, boolean noTouchRequired, boolean verifyRequired, PublicKey delegatePublicKey) {
        this.appName = appName;
        this.noTouchRequired = noTouchRequired;
        this.verifyRequired = verifyRequired;
        ValidateUtils.checkTrue("ssh-ed25519".equals(KeyUtils.getKeyType(delegatePublicKey)), "Key is not an ed25519 key");
        this.delegatePublicKey = delegatePublicKey;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getKeyType() {
        return "sk-ssh-ed25519@openssh.com";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isNoTouchRequired() {
        return this.noTouchRequired;
    }

    @Override
    public boolean isVerifyRequired() {
        return this.verifyRequired;
    }

    @Override
    public PublicKey getDelegatePublicKey() {
        return this.delegatePublicKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[appName=" + this.getAppName() + ", noTouchRequired=" + this.isNoTouchRequired() + ", verifyRequired=" + this.isVerifyRequired() + ", delegatePublicKey=" + this.getDelegatePublicKey() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.noTouchRequired, this.verifyRequired, this.delegatePublicKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkED25519PublicKey other = (SkED25519PublicKey)obj;
        return Objects.equals(this.appName, other.appName) && this.noTouchRequired == other.noTouchRequired && this.verifyRequired == other.verifyRequired && SecurityUtils.compareEDDSAPPublicKeys(this.delegatePublicKey, other.delegatePublicKey);
    }
}

