/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters.kex;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.filter.BufferInputHandler;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.filters.CompressionFilter;
import org.apache.sshd.common.session.filters.CryptFilter;
import org.apache.sshd.common.session.filters.kex.KexListener;
import org.apache.sshd.common.session.filters.kex.KexOutputHandler;
import org.apache.sshd.common.session.filters.kex.MessageCodingSettings;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KexFilter
extends IoFilter {
    private static final Logger LOG = LoggerFactory.getLogger(KexFilter.class);
    private final AtomicReference<byte[]> sessionId = new AtomicReference();
    private final CopyOnWriteArrayList<KexListener> listeners = new CopyOnWriteArrayList();
    private final AtomicBoolean firstKex = new AtomicBoolean();
    private final AtomicReference<KexState> kexState = new AtomicReference<KexState>(KexState.DONE);
    private final AtomicReference<DefaultKeyExchangeFuture> kexFuture = new AtomicReference();
    private final AtomicReference<Map<KexProposalOption, String>> negotiated = new AtomicReference<EnumMap<KexProposalOption, Map<KexProposalOption, String>>>(new EnumMap(KexProposalOption.class));
    private final AtomicReference<Map<KexProposalOption, String>> myProposal = new AtomicReference();
    private final AtomicReference<Map<KexProposalOption, String>> peerProposal = new AtomicReference();
    private final AtomicReference<byte[]> myData = new AtomicReference();
    private final AtomicReference<byte[]> peerData = new AtomicReference();
    private final AtomicReference<KeyExchange> kex = new AtomicReference();
    private final AtomicReference<MessageCodingSettings> inputSettings = new AtomicReference();
    private final AtomicReference<MessageCodingSettings> outputSettings = new AtomicReference();
    private final int maxMsgsBeforeKexInit;
    private final long rekeyAfterBytes;
    private final long rekeyAfterPackets;
    private final Duration rekeyAfter;
    private final AtomicReference<Instant> lastKexEnd = new AtomicReference<Instant>(Instant.now());
    private final KexInputHandler input = new KexInputHandler();
    private final KexOutputHandler output = new KexOutputHandler(this, LOG);
    private final Sender forward = new Sender();
    private final AbstractSession session;
    private final Random random;
    private final SessionListener signals;
    private final CryptFilter crypt;
    private final CompressionFilter compression;
    private final Proposer proposer;
    private final HostKeyChecker hostKeyChecker;
    private volatile String clientIdent;
    private volatile String serverIdent;
    private boolean firstKexPacketFollows;
    private DefaultKeyExchangeFuture myProposalReady;
    private volatile boolean initialKexDone;
    private volatile long rekeyAfterBlocks;
    private volatile boolean strictKex;
    private volatile long initialKexInitSequenceNumber;

    public KexFilter(AbstractSession session, Random random, CryptFilter crypt, CompressionFilter compression, SessionListener listener, Proposer proposer, HostKeyChecker checker) {
        this.session = Objects.requireNonNull(session);
        this.random = Objects.requireNonNull(random);
        this.crypt = Objects.requireNonNull(crypt);
        this.compression = Objects.requireNonNull(compression);
        this.signals = Objects.requireNonNull(listener);
        this.proposer = Objects.requireNonNull(proposer);
        if (!session.isServerSession()) {
            Objects.requireNonNull(checker);
        }
        this.hostKeyChecker = checker;
        this.maxMsgsBeforeKexInit = (Integer)CoreModuleProperties.MAX_MSGS_BEFORE_KEX_INIT.getRequired((PropertyResolver)session);
        this.rekeyAfterBytes = (Long)CoreModuleProperties.REKEY_BYTES_LIMIT.getRequired((PropertyResolver)session);
        this.rekeyAfterPackets = (Long)CoreModuleProperties.REKEY_PACKETS_LIMIT.getRequired((PropertyResolver)session);
        this.rekeyAfterBlocks = this.rekeyAfterBytes / 16L;
        Duration interval = (Duration)CoreModuleProperties.REKEY_TIME_LIMIT.getRequired((PropertyResolver)session);
        if (interval.compareTo(Duration.ZERO) <= 0) {
            interval = null;
        }
        this.rekeyAfter = interval;
    }

    AbstractSession getSession() {
        return this.session;
    }

    public boolean isStrictKex() {
        return this.strictKex;
    }

    public boolean isInitialKexDone() {
        return this.initialKexDone;
    }

    public AtomicReference<KexState> getKexState() {
        return this.kexState;
    }

    public Map<KexProposalOption, String> getNegotiated() {
        Map<KexProposalOption, String> result = this.negotiated.get();
        return result == null ? null : Collections.unmodifiableMap(result);
    }

    public Map<KexProposalOption, String> getClientProposal() {
        Map<KexProposalOption, String> result = this.session.isServerSession() ? this.peerProposal.get() : this.myProposal.get();
        return result == null ? null : Collections.unmodifiableMap(result);
    }

    public Map<KexProposalOption, String> getServerProposal() {
        Map<KexProposalOption, String> result = this.session.isServerSession() ? this.myProposal.get() : this.peerProposal.get();
        return result == null ? null : Collections.unmodifiableMap(result);
    }

    public void setClientIdent(String ident) {
        this.clientIdent = Objects.requireNonNull(ident);
    }

    public void setServerIdent(String ident) {
        this.serverIdent = Objects.requireNonNull(ident);
    }

    public byte[] getSessionId() {
        byte[] id = this.sessionId.get();
        return id == null ? null : (byte[])id.clone();
    }

    public void addKexListener(KexListener listener) {
        this.listeners.addIfAbsent(Objects.requireNonNull(listener));
    }

    public void removeKexListener(KexListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public InputHandler in() {
        return this.input;
    }

    @Override
    public OutputHandler out() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        KexFilter kexFilter = this;
        synchronized (kexFilter) {
            DefaultKeyExchangeFuture initFuture = this.myProposalReady;
            if (initFuture != null) {
                initFuture.setValue((Object)new SshException("Session closing while KEX in progress"));
            }
        }
        DefaultKeyExchangeFuture globalFuture = this.kexFuture.get();
        if (globalFuture != null) {
            globalFuture.setValue((Object)new SshException("Session closing while KEX in progress"));
        }
        this.output.shutdown();
    }

    private void exceptionCaught(Throwable t) {
        DefaultKeyExchangeFuture globalFuture = this.kexFuture.get();
        if (globalFuture != null) {
            globalFuture.setValue(t);
        }
        this.session.exceptionCaught(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveKexInit(Buffer message) throws Exception {
        DefaultKeyExchangeFuture initFuture;
        this.input.messagesBeforeKexInit.set(0L);
        KexStart starting = this.output.updateState(() -> {
            if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
                this.output.initNewKeyExchange();
                return KexStart.PEER;
            }
            if (this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
                return KexStart.BOTH;
            }
            return KexStart.ONGOING;
        });
        if (starting == KexStart.ONGOING) {
            throw new SshException(2, "KEX: received SSH_MSG_KEXINIT while already in KEX");
        }
        if (!this.initialKexDone) {
            this.initialKexInitSequenceNumber = this.crypt.getLastInputSequenceNumber();
        }
        this.parsePeerProposal(message);
        if (starting == KexStart.PEER) {
            this.listeners.forEach(listener -> listener.event(true));
            this.sendKexInit().addListener(f -> {
                if (!f.isWritten()) {
                    this.exceptionCaught(f.getException());
                }
            });
        }
        KexFilter kexFilter = this;
        synchronized (kexFilter) {
            initFuture = this.myProposalReady;
            if (initFuture == null) {
                this.myProposalReady = initFuture = new DefaultKeyExchangeFuture(this.session.toString(), null);
            }
        }
        initFuture.addListener(f -> {
            Throwable t = f.getException();
            if (t != null) {
                this.exceptionCaught(t);
            } else {
                try {
                    this.performNegotiation();
                }
                catch (Exception e) {
                    this.exceptionCaught(e);
                }
            }
        });
    }

    private void parsePeerProposal(Buffer message) throws Exception {
        KexExtensionHandler handler;
        byte[] data = new byte[message.available()];
        message.getRawBytes(data, 0, data.length);
        ByteArrayBuffer buf = new ByteArrayBuffer(data);
        buf.rpos(17);
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        for (KexProposalOption param : KexProposalOption.VALUES) {
            proposal.put(param, buf.getString());
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("parsePeerProposal({}) options before handler: {}", (Object)this.session, proposal);
        }
        if ((handler = this.session.getKexExtensionHandler()) != null) {
            handler.handleKexInitProposal(this.session, false, proposal);
            if (traceEnabled) {
                LOG.trace("parsePeerProposal({}) options after handler: {}", (Object)this.session, proposal);
            }
        }
        this.firstKexPacketFollows = buf.getBoolean();
        long reserved = buf.getUInt();
        if (reserved != 0L && traceEnabled) {
            LOG.trace("parsePeerProposal({}) non-zero reserved value: {}", (Object)this.session, (Object)reserved);
        }
        if (LOG.isDebugEnabled()) {
            for (KexProposalOption param : KexProposalOption.VALUES) {
                LOG.debug("parsePeerProposal({}) KEX peer: {} = {}", new Object[]{this.session, param, proposal.get(param)});
            }
        }
        if (buf.available() > 0) {
            throw new SshException(2, "KEX: received SSH_MSG_KEXINIT contains extra data at the end");
        }
        this.peerProposal.set(proposal);
        this.peerData.set(data);
    }

    private Map<KexProposalOption, String> doStrictKexProposal(Map<KexProposalOption, String> proposal) {
        String value = proposal.get(KexProposalOption.ALGORITHMS);
        boolean isServer = this.session.isServerSession();
        String askForStrictKex = isServer ? "kex-strict-s-v00@openssh.com" : "kex-strict-c-v00@openssh.com";
        LinkedHashSet<String> algorithms = new LinkedHashSet<String>(Arrays.asList(value.split(",")));
        boolean changed = false;
        if (!this.initialKexDone) {
            changed = algorithms.add(askForStrictKex);
        } else if (!GenericUtils.isEmpty((CharSequence)value)) {
            String extType = isServer ? "ext-info-s" : "ext-info-c";
            changed = algorithms.remove(extType);
            changed |= algorithms.remove(askForStrictKex);
        }
        if (changed) {
            proposal.put(KexProposalOption.ALGORITHMS, algorithms.stream().collect(Collectors.joining(",")));
        }
        return proposal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoWriteFuture sendKexInit() throws Exception {
        Map<KexProposalOption, String> proposal = this.doStrictKexProposal(this.proposer.get());
        Buffer message = this.session.createBuffer((byte)20);
        int wpos = message.wpos();
        message.wpos(wpos + 16);
        this.random.fill(message.array(), wpos, 16);
        boolean isDebugEnabled = LOG.isDebugEnabled();
        for (KexProposalOption param : KexProposalOption.VALUES) {
            String value = GenericUtils.trimToEmpty((String)proposal.get(param));
            if (isDebugEnabled) {
                LOG.debug("sendKexInit({}) KEX this: {} = {}", new Object[]{this.session, param, value});
            }
            message.putString(value);
        }
        message.putBoolean(false);
        message.putUInt(0L);
        DefaultKeyExchangeFuture initFuture = null;
        try {
            ReservedSessionMessagesHandler handler = this.session.getReservedSessionMessagesHandler();
            IoWriteFuture future = handler == null ? null : handler.sendKexInitRequest(this.session, proposal, message);
            byte[] data = message.getCompactData();
            this.myProposal.set(proposal);
            this.myData.set(data);
            KexFilter kexFilter = this;
            synchronized (kexFilter) {
                initFuture = this.myProposalReady;
                if (initFuture == null) {
                    this.myProposalReady = initFuture = new DefaultKeyExchangeFuture(this.session.toString(), null);
                }
            }
            if (future != null) {
                if (isDebugEnabled) {
                    LOG.debug("sendKexInit({}) : SSH_MSG_KEXINIT sent by reserved messages handler", (Object)this.session);
                }
            } else {
                future = this.forward.send(20, message);
            }
            initFuture.setValue(Boolean.TRUE);
            return future;
        }
        catch (Exception e) {
            if (initFuture != null) {
                initFuture.setValue(e);
            }
            throw e;
        }
    }

    private boolean removeValue(Map<KexProposalOption, String> options, KexProposalOption option, String toRemove) {
        String val = options.get(option);
        LinkedHashSet<String> algorithms = new LinkedHashSet<String>(Arrays.asList(val.split(",")));
        boolean result = algorithms.remove(toRemove);
        if (result) {
            options.put(option, algorithms.stream().collect(Collectors.joining(",")));
        }
        return result;
    }

    private String firstCommon(String[] client, String[] server) {
        for (String c : client) {
            for (String s : server) {
                if (!c.equals(s)) continue;
                return c;
            }
        }
        return null;
    }

    private boolean isAead(String encryption) {
        NamedFactory factory = (NamedFactory)NamedResource.findByName((String)encryption, String::compareTo, this.session.getCipherFactories());
        if (factory != null) {
            if (factory instanceof CipherFactory) {
                return ((CipherFactory)factory).getAuthenticationTagSize() > 0;
            }
            Cipher cipher = (Cipher)factory.create();
            return cipher != null && cipher.getAuthenticationTagSize() > 0;
        }
        return false;
    }

    private Map<KexProposalOption, String> negotiateProposal() throws Exception {
        boolean isServer = this.session.isServerSession();
        Map<KexProposalOption, String> client = isServer ? this.peerProposal.get() : this.myProposal.get();
        Map<KexProposalOption, String> server = isServer ? this.myProposal.get() : this.peerProposal.get();
        EnumMap<KexProposalOption, String> result = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        Map<KexProposalOption, String> cView = Collections.unmodifiableMap(client);
        Map<KexProposalOption, String> sView = Collections.unmodifiableMap(server);
        Map<KexProposalOption, String> rView = Collections.unmodifiableMap(result);
        this.signals.sessionNegotiationStart(this.session, cView, sView);
        boolean strictKexClient = this.removeValue(client, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com");
        boolean strictKexServer = this.removeValue(server, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com");
        if (this.removeValue(client, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com") && !this.initialKexDone) {
            LOG.warn("negotiate({}) client proposal contains server flag {}; will be ignored", (Object)this.session, (Object)"kex-strict-s-v00@openssh.com");
        }
        if (this.removeValue(server, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com") && !this.initialKexDone) {
            LOG.warn("negotiate({}) server proposal contains client flag {}; will be ignored", (Object)this.session, (Object)"kex-strict-c-v00@openssh.com");
        }
        try {
            boolean debugEnabled = LOG.isDebugEnabled();
            if (!this.initialKexDone) {
                boolean bl = this.strictKex = strictKexClient && strictKexServer;
                if (debugEnabled) {
                    LOG.debug("negotiate({}) strict KEX={} client={} server={}", new Object[]{this.session, this.strictKex, strictKexClient, strictKexServer});
                }
                if (this.strictKex && this.initialKexInitSequenceNumber != 0L) {
                    throw new SshException(3, MessageFormat.format("KEX: strict KEX negotiated but there were {0} messages before the first SSH_MSG_KEXINIT", this.initialKexInitSequenceNumber));
                }
            }
            KexExtensionHandler extHandler = this.session.getKexExtensionHandler();
            for (KexProposalOption param : KexProposalOption.VALUES) {
                if (param == KexProposalOption.C2SMAC && this.isAead((String)result.get(KexProposalOption.C2SENC)) || param == KexProposalOption.S2CMAC && this.isAead((String)result.get(KexProposalOption.S2CENC))) {
                    result.put(param, "aead");
                    continue;
                }
                String clientParamValue = client.get(param);
                String serverParamValue = server.get(param);
                String[] c = GenericUtils.split((String)clientParamValue, (char)',');
                String[] s = GenericUtils.split((String)serverParamValue, (char)',');
                String value = this.firstCommon(c, s);
                if (extHandler != null) {
                    extHandler.handleKexExtensionNegotiation(this.session, param, value, cView, clientParamValue, sView, serverParamValue);
                }
                if (value != null) {
                    if (this.isInvalid(param, value) && !this.acceptFailedNegotiation(cView, sView, rView, param, value)) {
                        throw new SshException(3, MessageFormat.format("Negotiated value for KEX {0}={1} is invalid: client={2} server={3}", param, value, clientParamValue, serverParamValue));
                    }
                    result.put(param, value);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("negotiate({}) {}={} (client={} / server={})", new Object[]{this.session, param.getDescription(), value, clientParamValue, serverParamValue});
                    continue;
                }
                if (param == KexProposalOption.C2SLANG || param == KexProposalOption.S2CLANG || this.acceptFailedNegotiation(cView, sView, rView, param, value)) continue;
                throw new SshException(3, MessageFormat.format("No negotiated value for KEX {0}: client={1} server={2}", param, clientParamValue, serverParamValue));
            }
        }
        catch (Exception e) {
            this.signals.sessionNegotiationEnd(this.session, cView, sView, rView, e);
            throw e;
        }
        this.negotiated.set(result);
        this.signals.sessionNegotiationEnd(this.session, cView, sView, rView, null);
        return result;
    }

    private boolean isInvalid(KexProposalOption param, String value) {
        switch (param) {
            case ALGORITHMS: {
                return KexExtensions.IS_KEX_EXTENSION_SIGNAL.test(value);
            }
            case C2SENC: 
            case S2CENC: {
                return value.equals(BuiltinCiphers.none.getName()) && !this.session.isAuthenticated();
            }
        }
        return false;
    }

    private boolean acceptFailedNegotiation(Map<KexProposalOption, String> client, Map<KexProposalOption, String> server, Map<KexProposalOption, String> result, KexProposalOption param, String value) {
        SessionDisconnectHandler disconnectHandler = this.session.getSessionDisconnectHandler();
        try {
            if (disconnectHandler != null && disconnectHandler.handleKexDisconnectReason(this.session, client, server, result, param)) {
                if (LOG.isDebugEnabled()) {
                    if (GenericUtils.isEmpty((CharSequence)value)) {
                        LOG.debug("negotiate({}) KEX: ignoring missing value for {}", (Object)this.session, (Object)param);
                    } else {
                        LOG.debug("negotiate({}) KEX: ignoring invalid {}={}", new Object[]{this.session, param, value});
                    }
                }
                return true;
            }
        }
        catch (IOException | RuntimeException e) {
            LoggingUtils.debug((Logger)LOG, (String)"negotiate({}) disconnect handler for {}={} failed: {}", (Object)this.session, (Object)param, (Object)value, (Object)e.toString(), (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNegotiation() throws Exception {
        Map<KexProposalOption, String> options = this.negotiateProposal();
        String kexAlgorithm = options.get(KexProposalOption.ALGORITHMS);
        List<KeyExchangeFactory> kexFactories = this.session.getKeyExchangeFactories();
        KeyExchangeFactory kexFactory = (KeyExchangeFactory)NamedResource.findByName((String)kexAlgorithm, (Comparator)String.CASE_INSENSITIVE_ORDER, kexFactories);
        ValidateUtils.checkNotNull((Object)kexFactory, (String)"Unknown negotiated KEX algorithm: %s", (Object)kexAlgorithm);
        boolean isServer = this.session.isServerSession();
        byte[] vS = this.serverIdent.getBytes(StandardCharsets.UTF_8);
        byte[] vC = this.clientIdent.getBytes(StandardCharsets.UTF_8);
        byte[] iS = isServer ? this.myData.get() : this.peerData.get();
        byte[] iC = isServer ? this.peerData.get() : this.myData.get();
        KeyExchange k = kexFactory.createKeyExchange(this.session);
        this.kex.set(k);
        k.init(vS, vC, iS, iC);
        KexFilter kexFilter = this;
        synchronized (kexFilter) {
            this.myProposalReady = null;
        }
        this.signals.sessionEvent(this.session, SessionListener.Event.KexCompleted);
    }

    private void prepareNewSettings() throws Exception {
        Mac c2smac;
        Mac s2cmac;
        KeyExchange exchange = this.kex.get();
        if (exchange == null) {
            throw new SshException(3, "No KEX");
        }
        byte[] k = exchange.getK();
        byte[] h = exchange.getH();
        Digest hash = exchange.getHash();
        byte[] sessionIdValue = this.sessionId.get();
        if (sessionIdValue == null) {
            sessionIdValue = (byte[])h.clone();
            this.sessionId.set(sessionIdValue);
            if (LOG.isDebugEnabled()) {
                LOG.debug("prepareNewSeetings({}) session ID={}", (Object)this.session, (Object)BufferUtils.toHex((char)':', (byte[])sessionIdValue));
            }
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putBytes(k);
        buffer.putRawBytes(h);
        int j = buffer.wpos();
        buffer.putByte((byte)65);
        buffer.putRawBytes(sessionIdValue);
        int pos = buffer.available();
        byte[] buf = buffer.array();
        hash.update(buf, 0, pos);
        byte[] iv_c2s = hash.digest();
        int n = j;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] iv_s2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] e_c2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] e_s2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_c2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_s2c = hash.digest();
        boolean serverSession = this.session.isServerSession();
        Map<KexProposalOption, String> options = this.negotiated.get();
        String value = options.get(KexProposalOption.S2CENC);
        Cipher s2ccipher = (Cipher)ValidateUtils.checkNotNull((Object)((Cipher)NamedFactory.create(this.session.getCipherFactories(), (String)value)), (String)"Unknown s2c cipher: %s", (Object)value);
        e_s2c = KexFilter.resizeKey(e_s2c, s2ccipher.getKdfSize(), hash, k, h);
        if (s2ccipher.getAuthenticationTagSize() == 0) {
            value = options.get(KexProposalOption.S2CMAC);
            s2cmac = (Mac)NamedFactory.create(this.session.getMacFactories(), (String)value);
            if (s2cmac == null) {
                throw new SshException(5, "Unknown s2c MAC: " + value);
            }
            mac_s2c = KexFilter.resizeKey(mac_s2c, s2cmac.getBlockSize(), hash, k, h);
            s2cmac.init(mac_s2c);
        } else {
            s2cmac = null;
        }
        value = options.get(KexProposalOption.S2CCOMP);
        Compression s2ccomp = (Compression)NamedFactory.create(this.session.getCompressionFactories(), (String)value);
        if (s2ccomp == null) {
            throw new SshException(6, "Unknown s2c compression: " + value);
        }
        value = options.get(KexProposalOption.C2SENC);
        Cipher c2scipher = (Cipher)ValidateUtils.checkNotNull((Object)((Cipher)NamedFactory.create(this.session.getCipherFactories(), (String)value)), (String)"Unknown c2s cipher: %s", (Object)value);
        e_c2s = KexFilter.resizeKey(e_c2s, c2scipher.getKdfSize(), hash, k, h);
        if (c2scipher.getAuthenticationTagSize() == 0) {
            value = options.get(KexProposalOption.C2SMAC);
            c2smac = (Mac)NamedFactory.create(this.session.getMacFactories(), (String)value);
            if (c2smac == null) {
                throw new SshException(5, "Unknown c2s MAC: " + value);
            }
            mac_c2s = KexFilter.resizeKey(mac_c2s, c2smac.getBlockSize(), hash, k, h);
            c2smac.init(mac_c2s);
        } else {
            c2smac = null;
        }
        value = options.get(KexProposalOption.C2SCOMP);
        Compression c2scomp = (Compression)NamedFactory.create(this.session.getCompressionFactories(), (String)value);
        if (c2scomp == null) {
            throw new SshException(6, "Unknown c2s compression: " + value);
        }
        if (serverSession) {
            this.outputSettings.set(new MessageCodingSettings(s2ccipher, s2cmac, s2ccomp, Cipher.Mode.Encrypt, e_s2c, iv_s2c));
            this.inputSettings.set(new MessageCodingSettings(c2scipher, c2smac, c2scomp, Cipher.Mode.Decrypt, e_c2s, iv_c2s));
        } else {
            this.outputSettings.set(new MessageCodingSettings(c2scipher, c2smac, c2scomp, Cipher.Mode.Encrypt, e_c2s, iv_c2s));
            this.inputSettings.set(new MessageCodingSettings(s2ccipher, s2cmac, s2ccomp, Cipher.Mode.Decrypt, e_s2c, iv_s2c));
        }
    }

    private static byte[] resizeKey(byte[] e, int kdfSize, Digest hash, byte[] k, byte[] h) throws Exception {
        ByteArrayBuffer buffer = null;
        while (kdfSize > e.length) {
            if (buffer == null) {
                buffer = new ByteArrayBuffer();
            } else {
                buffer.clear();
            }
            buffer.putBytes(k);
            buffer.putRawBytes(h);
            buffer.putRawBytes(e);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[e.length + foo.length];
            System.arraycopy(e, 0, bar, 0, e.length);
            System.arraycopy(foo, 0, bar, e.length, foo.length);
            e = bar;
        }
        BufferUtils.clear(buffer);
        return e;
    }

    private IoWriteFuture sendNewKeys() throws Exception {
        AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture> flushDone;
        int numPending;
        Buffer buffer = this.session.createBuffer((byte)21, 1);
        IoWriteFuture future = this.forward.send(21, buffer);
        this.setOutputEncoding();
        this.output.updateState(() -> this.kexState.set(KexState.KEYS));
        this.session.resetIdleTimeout();
        KexExtensionHandler extHandler = this.session.getKexExtensionHandler();
        if (extHandler != null && extHandler.isKexExtensionsAvailable(this.session, KexExtensionHandler.AvailabilityPhase.NEWKEYS)) {
            extHandler.sendKexExtensions(this.session, KexExtensionHandler.KexPhase.NEWKEYS);
        }
        if ((numPending = (flushDone = this.output.terminateKeyExchange()).getKey().intValue()) == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleNewKeys({}) No pending packets to flush at end of KEX", (Object)this.session);
            }
            flushDone.getValue().setValue(Boolean.TRUE);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handleNewKeys({}) {} pending packets to flush at end of KEX", (Object)this.session, (Object)numPending);
            }
            this.output.flushQueue(flushDone.getValue());
        }
        future.addListener(f -> {
            if (!f.isWritten()) {
                this.exceptionCaught(f.getException());
            }
        });
        return future;
    }

    private void setOutputEncoding() throws Exception {
        long maxRekeyBlocks;
        MessageCodingSettings out = this.outputSettings.get();
        Compression comp = out.getCompression();
        comp.init(Compression.Type.Deflater, -1);
        this.compression.setOutputCompression(comp);
        Cipher cipher = out.getCipher(this.strictKex ? 0L : this.crypt.getOutputSequenceNumber());
        Mac mac = out.getMac();
        this.crypt.setOutput(new CryptFilter.Settings(cipher, mac), this.strictKex);
        this.crypt.resetOutputCounters();
        this.outputSettings.set(null);
        Cipher inCipher = this.crypt.getInputSettings().getCipher();
        int inBlockSize = inCipher == null ? 8 : inCipher.getCipherBlockSize();
        this.rekeyAfterBlocks = maxRekeyBlocks = this.determineRekeyBlockLimit(inBlockSize, cipher.getCipherBlockSize());
        this.lastKexEnd.set(Instant.now());
        if (LOG.isDebugEnabled()) {
            LOG.debug("setOutputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this.session, cipher, mac, comp, maxRekeyBlocks});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveNewKeys(KexState currentState) throws Exception {
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug("receiveNewKeys({}) SSH_MSG_NEWKEYS", (Object)this.session);
        }
        if (currentState != KexState.KEYS) {
            throw new SshException(2, "KEX: received SSH_MSG_NEWKEYS in state " + currentState);
        }
        this.setInputEncoding();
        KexFilter kexFilter = this;
        synchronized (kexFilter) {
            this.myProposalReady = null;
        }
        this.initialKexDone = true;
        this.signals.sessionEvent(this.session, SessionListener.Event.KeyEstablished);
        this.listeners.forEach(listener -> listener.event(false));
        this.output.updateState(() -> {
            this.kex.set(null);
            this.kexState.set(KexState.DONE);
        });
        DefaultKeyExchangeFuture globalFuture = this.kexFuture.getAndSet(null);
        if (globalFuture != null) {
            globalFuture.setValue(Boolean.TRUE);
        }
    }

    private void setInputEncoding() throws Exception {
        MessageCodingSettings in = this.inputSettings.get();
        Compression comp = in.getCompression();
        comp.init(Compression.Type.Inflater, -1);
        this.compression.setInputCompression(comp);
        Cipher cipher = in.getCipher(this.strictKex ? 0L : this.crypt.getInputSequenceNumber());
        Mac mac = in.getMac();
        this.crypt.setInput(new CryptFilter.Settings(cipher, mac), this.strictKex);
        this.crypt.resetInputCounters();
        this.inputSettings.set(null);
        Cipher outCipher = this.crypt.getOutputSettings().getCipher();
        int outBlockSize = outCipher == null ? 8 : outCipher.getCipherBlockSize();
        long maxRekeyBlocks = this.determineRekeyBlockLimit(cipher.getCipherBlockSize(), outBlockSize);
        if (LOG.isDebugEnabled()) {
            LOG.debug("setInputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this.session, cipher, mac, comp, maxRekeyBlocks});
        }
    }

    private long determineRekeyBlockLimit(int inCipherBlockSize, int outCipherBlockSize) {
        long rekeyBlocksLimit = (Long)CoreModuleProperties.REKEY_BLOCKS_LIMIT.getRequired((PropertyResolver)this.session);
        if (rekeyBlocksLimit <= 0L) {
            int minCipherBlockBytes = Math.min(inCipherBlockSize, outCipherBlockSize);
            rekeyBlocksLimit = minCipherBlockBytes >= 16 ? 1L << Math.min(minCipherBlockBytes * 2, 63) : 0x40000000L / (long)minCipherBlockBytes;
        }
        return rekeyBlocksLimit;
    }

    private boolean isKexNeeded() {
        if (!this.initialKexDone || !this.session.isOpen()) {
            return false;
        }
        if (this.rekeyAfter != null && Duration.between(this.lastKexEnd.get(), Instant.now()).compareTo(this.rekeyAfter) >= 0) {
            return true;
        }
        CryptFilter.Counters counts = this.crypt.getInputCounters();
        if (this.rekeyAfterBlocks > 0L && this.rekeyAfterBlocks <= counts.getBlocks() || this.rekeyAfterBytes > 0L && this.rekeyAfterBytes <= counts.getBytes() || this.rekeyAfterPackets > 0L && this.rekeyAfterPackets <= counts.getPackets()) {
            return true;
        }
        counts = this.crypt.getOutputCounters();
        return this.rekeyAfterBlocks > 0L && this.rekeyAfterBlocks <= counts.getBlocks() || this.rekeyAfterBytes > 0L && this.rekeyAfterBytes <= counts.getBytes() || this.rekeyAfterPackets > 0L && this.rekeyAfterPackets <= counts.getPackets();
    }

    public KeyExchangeFuture startKex() throws Exception {
        DefaultKeyExchangeFuture result = new DefaultKeyExchangeFuture(this.session.toString(), this.session.getFutureLock());
        if (this.firstKex.compareAndSet(false, true) && !this.session.isServerSession() && !((Boolean)CoreModuleProperties.SEND_IMMEDIATE_KEXINIT.getRequired((PropertyResolver)this.session)).booleanValue()) {
            this.owner().send(-1, null);
            result.setValue(Boolean.FALSE);
            return result;
        }
        boolean start = this.output.updateState(() -> {
            if (this.kexState.compareAndSet(KexState.DONE, KexState.INIT)) {
                this.output.initNewKeyExchange();
                return true;
            }
            return false;
        });
        if (start) {
            this.listeners.forEach(listener -> listener.event(true));
            this.kexFuture.set(result);
            this.input.messagesBeforeKexInit.set(0L);
            this.sendKexInit().addListener(f -> {
                if (!f.isWritten()) {
                    this.exceptionCaught(f.getException());
                }
            });
        } else {
            result.setValue((Object)new SshException("KEX already ongoing"));
        }
        return result;
    }

    IoWriteFuture write(int cmd, Buffer buffer) throws IOException {
        return this.forward.send(cmd, buffer);
    }

    void startKexIfNeeded() throws IOException {
        KexState state = this.kexState.get();
        if (state == KexState.DONE && this.isKexNeeded()) {
            try {
                this.startKex();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    public static interface HostKeyChecker {
        public void check() throws IOException;
    }

    private class KexInputHandler
    extends WithSequenceNumber
    implements BufferInputHandler {
        final AtomicLong messagesBeforeKexInit;

        KexInputHandler() {
            this.messagesBeforeKexInit = new AtomicLong();
        }

        @Override
        public void handleMessage(Buffer message) throws Exception {
            KexState state;
            this.checkSequence();
            int cmd = message.rawByte(message.rpos()) & 0xFF;
            if (LOG.isDebugEnabled()) {
                LOG.debug("KexFilter.handleMessage({}) {} with packet size {}", new Object[]{KexFilter.this.getSession(), SshConstants.getCommandMessageName((int)cmd), message.available()});
            }
            if ((state = (KexState)KexFilter.this.kexState.get()) == KexState.DONE) {
                if (cmd == 20) {
                    KexFilter.this.receiveKexInit(message);
                } else {
                    if (KexFilter.this.isKexNeeded()) {
                        KexFilter.this.startKex();
                    }
                    KexFilter.this.owner().passOn((Readable)message);
                }
                return;
            }
            if (this.isKexMessage(cmd)) {
                if (cmd == 20) {
                    KexFilter.this.receiveKexInit(message);
                } else if (cmd == 21) {
                    if (message.available() != 1) {
                        throw new SshException(2, "KEX: SSH_MSG_NEWKEYS has extra data");
                    }
                    KexFilter.this.receiveNewKeys(state);
                } else {
                    this.handleKexMessage(state, message.getUByte(), message);
                }
            } else {
                if (state == KexState.INIT) {
                    this.passOnBeforeKexInit(cmd, message);
                    return;
                }
                if (KexFilter.this.strictKex && !KexFilter.this.initialKexDone && cmd != 1) {
                    throw new SshException(3, MessageFormat.format("{0} not allowed during initial key exchange in strict KEX", SshConstants.getCommandMessageName((int)cmd)));
                }
                if (cmd > 4) {
                    throw new SshException(3, MessageFormat.format("{0} not allowed during key exchange", SshConstants.getCommandMessageName((int)cmd)));
                }
                KexFilter.this.owner().passOn((Readable)message);
            }
        }

        private boolean isKexMessage(int cmd) {
            return cmd >= 20 && cmd <= 49;
        }

        private boolean isWantReply(Buffer message, boolean isChannelRequest) {
            long length;
            boolean wantReply = false;
            int mark = message.rpos();
            message.getUByte();
            if (isChannelRequest) {
                message.getUInt();
            }
            if ((length = message.getUInt()) < (long)message.available()) {
                wantReply = message.rawByte(message.rpos() + (int)length) != 0;
            }
            message.rpos(mark);
            return wantReply;
        }

        private void passOnBeforeKexInit(int cmd, Buffer message) throws Exception {
            if (KexFilter.this.maxMsgsBeforeKexInit > 0) {
                long valueNow = 0L;
                switch (cmd) {
                    case 80: {
                        if (!this.isWantReply(message, false)) break;
                        valueNow = this.messagesBeforeKexInit.incrementAndGet();
                        break;
                    }
                    case 98: {
                        if (!this.isWantReply(message, true)) break;
                        valueNow = this.messagesBeforeKexInit.incrementAndGet();
                        break;
                    }
                    case 90: {
                        valueNow = this.messagesBeforeKexInit.incrementAndGet();
                        break;
                    }
                }
                if (valueNow > (long)KexFilter.this.maxMsgsBeforeKexInit) {
                    throw new SshException(2, "KEX: no SSH_MSG_KEX_INIT received from peer within MAX_MSGS_BEFORE_KEX_INIT limit " + KexFilter.this.maxMsgsBeforeKexInit);
                }
            }
            KexFilter.this.owner().passOn((Readable)message);
        }

        private void handleKexMessage(KexState state, int cmd, Buffer message) throws Exception {
            KeyExchange exchange;
            if (state != KexState.RUN) {
                throw new SshException(2, MessageFormat.format("KEX message {0} received while not in running KEX", SshConstants.getCommandMessageName((int)cmd)));
            }
            if (KexFilter.this.firstKexPacketFollows) {
                KexFilter.this.firstKexPacketFollows = false;
                for (KexProposalOption param : KexProposalOption.FIRST_KEX_PACKET_GUESS_MATCHES) {
                    String common = (String)((Map)KexFilter.this.negotiated.get()).get(param);
                    String my = ((String)((Map)KexFilter.this.myProposal.get()).get(param)).split(",", 1)[0];
                    String peer = ((String)((Map)KexFilter.this.peerProposal.get()).get(param)).split(",", 1)[0];
                    if (common.equals(my) && common.equals(peer)) continue;
                    return;
                }
            }
            if ((exchange = (KeyExchange)KexFilter.this.kex.get()) == null) {
                throw new SshException(2, MessageFormat.format("KEX message {0} received at the wrong time in KEX", SshConstants.getCommandMessageName((int)cmd)));
            }
            if (exchange.next(cmd, message)) {
                if (KexFilter.this.hostKeyChecker != null) {
                    KexFilter.this.hostKeyChecker.check();
                }
                KexFilter.this.prepareNewSettings();
                KexFilter.this.sendNewKeys();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("handleKexMessage({})[{}] more KEX packets expected after cmd={}", new Object[]{KexFilter.this.session, exchange.getName(), cmd});
            }
        }
    }

    private class Sender
    implements OutputHandler {
        Sender() {
        }

        @Override
        public IoWriteFuture send(int cmd, Buffer message) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("KexFilter.send({}) {} with packet size {}", new Object[]{KexFilter.this.getSession(), SshConstants.getCommandMessageName((int)cmd), message.available()});
            }
            return KexFilter.this.owner().send(cmd, message);
        }
    }

    public static interface Proposer {
        public Map<KexProposalOption, String> get() throws Exception;
    }

    private static enum KexStart {
        PEER,
        BOTH,
        ONGOING;

    }

    private abstract class WithSequenceNumber {
        private long initialSequenceNumber;
        private boolean first = true;

        WithSequenceNumber() {
        }

        protected void checkSequence() throws SshException {
            if (KexFilter.this.initialKexDone) {
                return;
            }
            if (this.first) {
                this.first = false;
                this.initialSequenceNumber = KexFilter.this.crypt.getLastInputSequenceNumber();
            } else if (this.initialSequenceNumber == KexFilter.this.crypt.getLastInputSequenceNumber()) {
                throw new SshException(3, "Incoming sequence number wraps around during initial KEX");
            }
        }
    }
}

