/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.assertj.core.util.Lists;

public class ClassUtils {
    private static final List<Class<?>> PRIMITIVE_WRAPPER_TYPES = Lists.list(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Void.class);
    private static final List<Class<?>> OPTIONAL_TYPES = Lists.list(Optional.class, OptionalLong.class, OptionalDouble.class, OptionalInt.class);

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassUtils.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassUtils.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || PRIMITIVE_WRAPPER_TYPES.contains(type);
    }

    public static boolean isOptionalOrPrimitiveOptional(Class<?> type) {
        if (type == null) {
            return false;
        }
        return OPTIONAL_TYPES.contains(type);
    }
}

