/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.auth.UserAuthFactoriesManager;
import org.apache.sshd.common.auth.UserAuthInstance;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.slf4j.Logger;

public abstract class CliSupport {
    public static final BuiltinIoServiceFactoryFactories DEFAULT_IO_SERVICE_FACTORY = BuiltinIoServiceFactoryFactories.NIO2;

    protected CliSupport() {
    }

    public static <S extends SessionContext, M extends UserAuthInstance<S>, F extends UserAuthMethodFactory<S, M>, I extends UserAuthFactoriesManager<S, M, F>> void setupUserAuthFactories(I manager, PropertyResolver options) {
        String methods = options.getString("PreferredAuthentications");
        if (GenericUtils.isNotEmpty((CharSequence)methods)) {
            manager.setUserAuthFactoriesNameList(methods);
            return;
        }
    }

    public static BuiltinIoServiceFactoryFactories resolveIoServiceFactory(PrintStream stderr, String ... args) {
        int numArgs = GenericUtils.length((Object[])args);
        BuiltinIoServiceFactoryFactories factory = null;
        for (int index = 0; index < numArgs; ++index) {
            String argName = args[index];
            if (!"-io".equals(argName)) continue;
            if (factory != null) {
                stderr.println("I/O factory re-specified - already set as " + factory);
                return null;
            }
            if (++index >= numArgs) {
                stderr.println("option requires an argument: " + argName);
                return null;
            }
            String provider = args[index];
            factory = CliSupport.resolveBuiltinIoServiceFactory(stderr, argName, provider);
            if (factory != null) continue;
            return null;
        }
        if (factory == null) {
            factory = DEFAULT_IO_SERVICE_FACTORY;
        }
        System.setProperty(IoServiceFactoryFactory.class.getName(), factory.getFactoryClassName());
        return factory;
    }

    public static BuiltinIoServiceFactoryFactories resolveBuiltinIoServiceFactory(PrintStream stderr, String argName, String provider) {
        BuiltinIoServiceFactoryFactories factory = BuiltinIoServiceFactoryFactories.fromFactoryName((String)provider);
        if (factory == null) {
            System.err.println(argName + " - unknown provider (" + provider + ") should be one of " + BuiltinIoServiceFactoryFactories.VALUES);
        }
        return factory;
    }

    public static <M extends AbstractFactoryManager> M setupIoServiceFactory(M manager, PropertyResolver resolver, Level level, PrintStream stdout, PrintStream stderr, String ... args) {
        BuiltinIoServiceFactoryFactories factory = CliSupport.resolveIoServiceFactory(stderr, args);
        if (factory == null) {
            return null;
        }
        manager.setIoServiceFactoryFactory(factory.create());
        Logger logger = CliLogger.resolveLogger(CliSupport.class, level, stdout, stderr);
        if (logger.isInfoEnabled()) {
            manager.setIoServiceEventListener(CliSupport.createLoggingIoServiceEventListener(logger));
            manager.addSessionListener(CliSupport.createLoggingSessionListener(logger));
        }
        return manager;
    }

    public static IoServiceEventListener createLoggingIoServiceEventListener(final Logger logger) {
        return new IoServiceEventListener(){

            public void connectionEstablished(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote) throws IOException {
                logger.info("Connection established via {} - local={}, remote={}", new Object[]{connector, local, remote});
            }

            public void abortEstablishedConnection(IoConnector connector, SocketAddress local, AttributeRepository context, SocketAddress remote, Throwable reason) throws IOException {
                logger.info("Abort established connection {}  - local={}, remote={}", new Object[]{connector, local, remote});
                if (reason != null) {
                    logger.warn("     {}: {}", (Object)reason.getClass().getSimpleName(), (Object)reason.getMessage());
                    logger.error(reason.getClass().getSimpleName(), reason);
                }
            }

            public void connectionAccepted(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service) throws IOException {
                logger.info("Connection accepted via {} - local={}, remote={}, service={}", new Object[]{acceptor, local, remote, service});
            }

            public void abortAcceptedConnection(IoAcceptor acceptor, SocketAddress local, SocketAddress remote, SocketAddress service, Throwable reason) throws IOException {
                logger.info("Abort accepted connection {} - local={}, remote={}, service={}", new Object[]{acceptor, local, remote, service});
                if (reason != null) {
                    logger.warn("     {}: {}", (Object)reason.getClass().getSimpleName(), (Object)reason.getMessage());
                    logger.error(reason.getClass().getSimpleName(), reason);
                }
            }
        };
    }

    public static SessionListener createLoggingSessionListener(final Logger logger) {
        return new SessionListener(){

            public void sessionPeerIdentificationReceived(Session session, String version, List<String> extraLines) {
                logger.info("{} peer identification={}", (Object)session, (Object)version);
                if (GenericUtils.isNotEmpty(extraLines)) {
                    for (String l : extraLines) {
                        logger.info("    => {}", (Object)l);
                    }
                }
            }

            public void sessionNegotiationEnd(Session session, Map<KexProposalOption, String> clientProposal, Map<KexProposalOption, String> serverProposal, Map<KexProposalOption, String> negotiatedOptions, Throwable reason) {
                if (reason != null) {
                    return;
                }
                logger.info("{} KEX negotiation results:", (Object)session);
                for (KexProposalOption opt : KexProposalOption.VALUES) {
                    logger.info("    {}: {}", (Object)opt.getDescription(), (Object)negotiatedOptions.get(opt));
                }
            }

            public void sessionException(Session session, Throwable t) {
                logger.error("{} {}: {}", new Object[]{session, t.getClass().getSimpleName(), t.getMessage()});
                logger.error(t.getClass().getSimpleName(), t);
            }

            public void sessionClosed(Session session) {
                logger.info("{} closed", (Object)session);
            }
        };
    }

    public static List<NamedFactory<Compression>> setupCompressions(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"Compression");
        if (GenericUtils.isEmpty((CharSequence)argVal)) {
            return Collections.emptyList();
        }
        CompressionConfigValue value = CompressionConfigValue.fromName((String)argVal);
        if (value == null) {
            CliLogger.showError(stderr, "Unknown compression configuration value: " + argVal);
            return null;
        }
        return Collections.singletonList(value);
    }

    public static List<NamedFactory<Compression>> setupCompressions(String argName, String argVal, List<NamedFactory<Compression>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliLogger.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliLogger.showError(stderr, "No known compressions in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported compressions: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Compression>>(available);
    }

    public static List<NamedFactory<Mac>> setupMacs(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"MACs");
        return GenericUtils.isEmpty((CharSequence)argVal) ? Collections.emptyList() : CliSupport.setupMacs("MACs", argVal, null, stderr);
    }

    public static List<NamedFactory<Mac>> setupMacs(String argName, String argVal, List<NamedFactory<Mac>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliLogger.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliLogger.showError(stderr, "No known MACs in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported MACs: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Mac>>(available);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(PropertyResolver options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString((PropertyResolver)options, (String)"Ciphers");
        return GenericUtils.isEmpty((CharSequence)argVal) ? Collections.emptyList() : CliSupport.setupCiphers("Ciphers", argVal, null, stderr);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(String argName, String argVal, List<NamedFactory<Cipher>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            CliLogger.showError(stderr, argName + " option value re-specified: " + NamedResource.getNames(current));
            return null;
        }
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList((String)argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty((Collection)available)) {
            CliLogger.showError(stderr, "WARNING: No known ciphers in " + argVal);
            return null;
        }
        List unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size((Collection)unsupported) > 0) {
            stderr.append("WARNING: Ignored unsupported ciphers: ").println(GenericUtils.join((Iterable)unsupported, (char)','));
        }
        return new ArrayList<NamedFactory<Cipher>>(available);
    }

    public static String[] splitCommandLineArguments(String line) {
        if (GenericUtils.isBlank((CharSequence)(line = GenericUtils.trimToEmpty((String)line)))) {
            return GenericUtils.EMPTY_STRING_ARRAY;
        }
        List<String> args = Collections.emptyList();
        for (int index = 0; index < "\"'".length(); ++index) {
            String prefix;
            Object[] extra;
            char delim = "\"'".charAt(index);
            int startPos = line.indexOf(delim);
            int endPos = -1;
            if (startPos >= 0) {
                endPos = line.indexOf(delim, startPos + 1);
            }
            if (startPos < 0 || endPos <= startPos) continue;
            if (GenericUtils.isEmpty(args)) {
                args = new LinkedList();
            }
            if (!GenericUtils.isEmpty((Object[])(extra = GenericUtils.split((String)(prefix = startPos > 0 ? line.substring(0, startPos).trim() : ""), (char)' ')))) {
                args.addAll(Arrays.asList(extra));
            }
            String value = line.substring(startPos + 1, endPos);
            args.add(value);
            String string = line = endPos < line.length() - 1 ? line.substring(endPos + 1).trim() : "";
            if (GenericUtils.isBlank((CharSequence)line)) break;
            index = -1;
        }
        Object[] extra = GenericUtils.split((String)line, (char)' ');
        if (GenericUtils.isEmpty(args)) {
            return extra;
        }
        if (!GenericUtils.isEmpty((Object[])extra)) {
            if (GenericUtils.isEmpty(args)) {
                args = new LinkedList();
            }
            args.addAll(Arrays.asList(extra));
        }
        return args.toArray(GenericUtils.EMPTY_STRING_ARRAY);
    }

    public static void printFieldsValues(Object info, PrintStream stdout) throws Exception {
        Field[] fields;
        for (Field f : fields = info.getClass().getFields()) {
            String name = f.getName();
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            Object value = f.get(info);
            stdout.append("    ").append(name).append(": ").println(value);
        }
    }
}

