/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.session.SessionFactoryLocator;
import org.springframework.lang.Nullable;

public class DefaultSessionFactoryLocator<F>
implements SessionFactoryLocator<F> {
    private final Map<Object, SessionFactory<F>> factories = new ConcurrentHashMap<Object, SessionFactory<F>>();
    @Nullable
    private final SessionFactory<F> defaultFactory;

    public DefaultSessionFactoryLocator(Map<Object, SessionFactory<F>> factories) {
        this(factories, null);
    }

    public DefaultSessionFactoryLocator(Map<Object, SessionFactory<F>> factories, @Nullable SessionFactory<F> defaultFactory) {
        this.factories.putAll(factories);
        this.defaultFactory = defaultFactory;
    }

    @Deprecated
    public void addSessionFactory(String key, SessionFactory<F> factory) {
        this.addSessionFactory((Object)key, factory);
    }

    public void addSessionFactory(Object key, SessionFactory<F> factory) {
        this.factories.put(key, factory);
    }

    public SessionFactory<F> removeSessionFactory(Object key) {
        return this.factories.remove(key);
    }

    @Override
    public SessionFactory<F> getSessionFactory(@Nullable Object key) {
        return key == null ? this.defaultFactory : this.factories.getOrDefault(key, this.defaultFactory);
    }
}

