/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.annotation;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class BOMInputStream
extends FilterInputStream {
    private int[] firstBytes;
    private int fbLength;
    private int fbIndex;
    private int markFbIndex;
    private boolean markedAtStart;
    private static final int[][] BOMS = new int[][]{{239, 187, 191}, {254, 255}, {255, 254}};

    BOMInputStream(InputStream s) {
        super(s);
    }

    public int read() throws IOException {
        int b = this.readFirstBytes();
        return b >= 0 ? b : this.in.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int firstCount = 0;
        int b = 0;
        while (len > 0 && b >= 0) {
            b = this.readFirstBytes();
            if (b < 0) continue;
            buf[off++] = (byte)(b & 0xFF);
            --len;
            ++firstCount;
        }
        int secondCount = this.in.read(buf, off, len);
        return secondCount < 0 ? (firstCount > 0 ? firstCount : -1) : firstCount + secondCount;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    private int readFirstBytes() throws IOException {
        this.getBOM();
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : -1;
    }

    private void getBOM() throws IOException {
        if (this.firstBytes == null) {
            int max = 0;
            for (int[] BOM : BOMS) {
                max = Math.max(max, BOM.length);
            }
            this.firstBytes = new int[max];
            for (int i = 0; i < this.firstBytes.length; ++i) {
                this.firstBytes[i] = this.in.read();
                ++this.fbLength;
                if (this.firstBytes[i] < 0) break;
                boolean found = this.find();
                if (!found) continue;
                this.fbLength = 0;
                break;
            }
        }
    }

    public synchronized void mark(int readlimit) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    public long skip(long n) throws IOException {
        while (n > 0L && this.readFirstBytes() >= 0) {
            --n;
        }
        return this.in.skip(n);
    }

    private boolean find() {
        for (int[] BOM : BOMS) {
            if (!this.matches(BOM)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(int[] bom) {
        if (bom.length != this.fbLength) {
            return false;
        }
        for (int i = 0; i < bom.length; ++i) {
            if (bom[i] == this.firstBytes[i]) continue;
            return false;
        }
        return true;
    }
}

