/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.hash.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.datapage.DataPageReader;
import org.apache.ignite.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.pagememory.index.InlineUtils;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.internal.storage.pagememory.index.freelist.ReadIndexColumnsValue;
import org.apache.ignite.internal.storage.pagememory.index.hash.CompareIndexColumnsValue;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRow;
import org.apache.ignite.internal.storage.pagememory.index.hash.HashIndexRowKey;
import org.apache.ignite.internal.util.GridUnsafe;

public interface HashIndexTreeIo {
    public static final int ITEM_SIZE_WITHOUT_COLUMNS = 28;
    public static final short NOT_FULLY_INLINE = -1;
    public static final int HASH_OFFSET = 0;
    public static final int SIZE_OFFSET = 4;
    public static final int TUPLE_OFFSET = 6;

    default public int linkOffset() {
        return 6 + this.indexColumnsInlineSize();
    }

    default public int rowIdMsbOffset() {
        return this.linkOffset() + 6;
    }

    default public int rowIdLsbOffset() {
        return this.rowIdMsbOffset() + 8;
    }

    public int getItemSize();

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<HashIndexRowKey> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory((long)srcPageAddr, (long)srcOffset, (long)dstPageAddr, (long)dstOffset, (long)this.getItemSize());
    }

    default public void storeByOffset(long pageAddr, int off, HashIndexRowKey rowKey) {
        if (!1.$assertionsDisabled && !(rowKey instanceof HashIndexRow)) {
            throw new AssertionError();
        }
        HashIndexRow row = (HashIndexRow)rowKey;
        PageUtils.putInt((long)(pageAddr + (long)off), (int)0, (int)row.indexColumnsHash());
        IndexColumns indexColumns = row.indexColumns();
        if (InlineUtils.canFullyInline(indexColumns.valueSize(), this.indexColumnsInlineSize())) {
            if (!1.$assertionsDisabled && indexColumns.link() != 0L) {
                throw new AssertionError((Object)"Index columns are completely inline, they should not be in FreeList");
            }
            PageUtils.putShort((long)(pageAddr + (long)off), (int)4, (short)((short)indexColumns.valueSize()));
            PageUtils.putByteBuffer((long)(pageAddr + (long)off), (int)6, (ByteBuffer)indexColumns.valueBuffer().rewind());
        } else {
            PageUtils.putShort((long)(pageAddr + (long)off), (int)4, (short)-1);
            ByteBuffer bufferToWrite = indexColumns.valueBuffer().rewind().duplicate().limit(this.indexColumnsInlineSize());
            PageUtils.putByteBuffer((long)(pageAddr + (long)off), (int)6, (ByteBuffer)bufferToWrite);
            PartitionlessLinks.writePartitionless((long)(pageAddr + (long)off + (long)this.linkOffset()), (long)indexColumns.link());
        }
        RowId rowId = row.rowId();
        PageUtils.putLong((long)(pageAddr + (long)off), (int)this.rowIdMsbOffset(), (long)rowId.mostSignificantBits());
        PageUtils.putLong((long)(pageAddr + (long)off), (int)this.rowIdLsbOffset(), (long)rowId.leastSignificantBits());
    }

    default public int compare(DataPageReader dataPageReader, int partitionId, long pageAddr, int idx, HashIndexRowKey rowKey) throws IgniteInternalCheckedException {
        ByteBuffer indexColumnsBuffer;
        if (!1.$assertionsDisabled && !(rowKey instanceof HashIndexRow)) {
            throw new AssertionError();
        }
        HashIndexRow row = (HashIndexRow)rowKey;
        int off = this.offset(idx);
        int cmp = Integer.compare(PageUtils.getInt((long)(pageAddr + (long)off), (int)0), row.indexColumnsHash());
        if (cmp != 0) {
            return cmp;
        }
        int indexColumnsSize = PageUtils.getShort((long)(pageAddr + (long)off), (int)4);
        if (indexColumnsSize == -1) {
            indexColumnsSize = this.indexColumnsInlineSize();
            indexColumnsBuffer = GridUnsafe.wrapPointer((long)(pageAddr + (long)off + 6L), (int)indexColumnsSize);
            cmp = indexColumnsBuffer.compareTo(row.indexColumns().valueBuffer().rewind().duplicate().limit(indexColumnsSize));
            if (cmp != 0) {
                return cmp;
            }
            long link = PartitionlessLinks.readPartitionless((int)partitionId, (long)(pageAddr + (long)off), (int)this.linkOffset());
            CompareIndexColumnsValue compareIndexColumnsValue = new CompareIndexColumnsValue();
            dataPageReader.traverse(link, (PageMemoryTraversal)compareIndexColumnsValue, (Object)row.indexColumns().valueBuffer().rewind().duplicate());
            cmp = compareIndexColumnsValue.compareResult();
        } else {
            indexColumnsBuffer = GridUnsafe.wrapPointer((long)(pageAddr + (long)off + 6L), (int)indexColumnsSize);
            cmp = indexColumnsBuffer.compareTo(row.indexColumns().valueBuffer().rewind());
        }
        if (cmp != 0) {
            return cmp;
        }
        long rowIdMsb = PageUtils.getLong((long)(pageAddr + (long)off), (int)this.rowIdMsbOffset());
        cmp = Long.compare(rowIdMsb, row.rowId().mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        long rowIdLsb = PageUtils.getLong((long)(pageAddr + (long)off), (int)this.rowIdLsbOffset());
        return Long.compare(rowIdLsb, row.rowId().leastSignificantBits());
    }

    default public HashIndexRow getRow(DataPageReader dataPageReader, int partitionId, long pageAddr, int idx) throws IgniteInternalCheckedException {
        byte[] indexColumnsBytes;
        long link;
        int off = this.offset(idx);
        int hash = PageUtils.getInt((long)(pageAddr + (long)off), (int)0);
        short indexColumnsSize = PageUtils.getShort((long)(pageAddr + (long)off), (int)4);
        if (indexColumnsSize == -1) {
            link = PartitionlessLinks.readPartitionless((int)partitionId, (long)(pageAddr + (long)off), (int)this.linkOffset());
            ReadIndexColumnsValue indexColumnsTraversal = new ReadIndexColumnsValue();
            dataPageReader.traverse(link, (PageMemoryTraversal)indexColumnsTraversal, null);
            indexColumnsBytes = indexColumnsTraversal.result();
        } else {
            indexColumnsBytes = PageUtils.getBytes((long)(pageAddr + (long)off), (int)6, (int)indexColumnsSize);
            link = 0L;
        }
        IndexColumns indexColumns = new IndexColumns(partitionId, link, ByteBuffer.wrap(indexColumnsBytes).order(ByteOrder.LITTLE_ENDIAN));
        long rowIdMsb = PageUtils.getLong((long)(pageAddr + (long)off), (int)this.rowIdMsbOffset());
        long rowIdLsb = PageUtils.getLong((long)(pageAddr + (long)off), (int)this.rowIdLsbOffset());
        RowId rowId = new RowId(partitionId, rowIdMsb, rowIdLsb);
        return new HashIndexRow(hash, indexColumns, rowId);
    }

    default public int indexColumnsInlineSize() {
        return this.getItemSize() - 28;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

