/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public final class IgniteSqlTypeNameSpec
extends SqlTypeNameSpec {
    private static final int UNDEFINED_PRECISION = -1;
    private final int precision;

    public IgniteSqlTypeNameSpec(SqlIdentifier name, @Nullable SqlLiteral precision, SqlParserPos pos) {
        super(name, pos);
        this.precision = precision != null ? precision.intValue(true) : -1;
    }

    public IgniteSqlTypeNameSpec(SqlIdentifier name, SqlParserPos pos) {
        this(name, null, pos);
    }

    public RelDataType deriveType(SqlValidator validator) {
        IgniteTypeFactory typeFactory = (IgniteTypeFactory)validator.getTypeFactory();
        return typeFactory.createCustomType(this.getTypeName().getSimple(), this.precision);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword(this.getTypeName().getSimple());
        if (this.precision != -1) {
            SqlWriter.Frame frame = writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
            writer.print(this.precision);
            writer.endList(frame);
        }
    }

    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof IgniteSqlTypeNameSpec)) {
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        IgniteSqlTypeNameSpec that = (IgniteSqlTypeNameSpec)spec;
        if (that.precision != this.precision) {
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        return litmus.succeed();
    }
}

