/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.metadata.IgniteMdPercentageOriginalRows;
import org.apache.ignite.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIgniteDataSource
extends AbstractTable
implements IgniteDataSource,
BuiltInMetadata.PercentageOriginalRows.Handler {
    private final String name;
    private final TableDescriptor desc;
    private final int id;
    private final int version;
    private final Statistic statistic;

    public AbstractIgniteDataSource(String name, int id, int version, TableDescriptor desc, Statistic statistic) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.version = version;
        this.statistic = statistic;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.getRowType(typeFactory, null);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, ImmutableBitSet requiredColumns) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, requiredColumns);
    }

    public final TableScan toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)this.distribution());
        return this.toRel(cluster, traitSet, relOptTable, context.getTableHints());
    }

    protected abstract TableScan toRel(RelOptCluster var1, RelTraitSet var2, RelOptTable var3, List<RelHint> var4);

    @Override
    public IgniteDistribution distribution() {
        return this.desc.distribution();
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
        return false;
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    @Nullable
    public <C> C unwrap(Class<C> cls) {
        if (cls.isInstance(this.desc)) {
            return cls.cast(this.desc);
        }
        return (C)super.unwrap(cls);
    }

    @Nullable
    public Double getPercentageOriginalRows(RelNode r, RelMetadataQuery mq) {
        Double tableRowCount = this.statistic.getRowCount();
        Double relRowCount = mq.getRowCount(r);
        if (tableRowCount == null || relRowCount == null) {
            return null;
        }
        return IgniteMdPercentageOriginalRows.quotientForPercentage(relRowCount, tableRowCount);
    }
}

