/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.sql.engine.exec.mapping.MappingException;
import org.apache.ignite.internal.sql.engine.message.UnknownNodeException;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.CursorClosedException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.TraceableException;
import org.apache.ignite.sql.SqlException;

public class SqlExceptionMapperUtil {
    public static Throwable mapToPublicSqlException(Throwable origin) {
        Throwable unwrapped = ExceptionUtils.unwrapCause((Throwable)origin);
        if (unwrapped instanceof MappingException) {
            return new SqlException(ErrorGroups.Sql.MAPPING_ERR, unwrapped.getMessage());
        }
        if (unwrapped instanceof UnknownNodeException) {
            return new SqlException(ErrorGroups.Common.NODE_LEFT_ERR, "Node left the cluster. Node: " + ((UnknownNodeException)unwrapped).nodeName());
        }
        Throwable e = IgniteExceptionMapperUtil.mapToPublicException((Throwable)origin);
        if (e instanceof Error) {
            return e;
        }
        if (e instanceof SqlException || e instanceof CursorClosedException) {
            return e;
        }
        if (e instanceof TraceableException) {
            TraceableException traceable = (TraceableException)e;
            return new SqlException(traceable.traceId(), traceable.code(), e.getMessage(), e);
        }
        return new SqlException(ErrorGroups.Common.INTERNAL_ERR, origin);
    }
}

