/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.internal.schema.row.RowAssembler;

class RowWriter
implements MarshallerWriter {
    private final RowAssembler rowAssembler;

    RowWriter(RowAssembler rowAssembler) {
        this.rowAssembler = rowAssembler;
    }

    public void writeNull() {
        this.rowAssembler.appendNull();
    }

    public void writeAbsentValue() {
        this.rowAssembler.appendDefault();
    }

    public void writeBoolean(boolean val) {
        this.rowAssembler.appendBoolean(val);
    }

    public void writeByte(byte val) {
        this.rowAssembler.appendByte(val);
    }

    public void writeShort(short val) {
        this.rowAssembler.appendShort(val);
    }

    public void writeInt(int val) {
        this.rowAssembler.appendInt(val);
    }

    public void writeLong(long val) {
        this.rowAssembler.appendLong(val);
    }

    public void writeFloat(float val) {
        this.rowAssembler.appendFloat(val);
    }

    public void writeDouble(double val) {
        this.rowAssembler.appendDouble(val);
    }

    public void writeString(String val) {
        this.rowAssembler.appendStringNotNull(val);
    }

    public void writeUuid(UUID val) {
        this.rowAssembler.appendUuidNotNull(val);
    }

    public void writeBytes(byte[] val) {
        this.rowAssembler.appendBytesNotNull(val);
    }

    public void writeBigDecimal(BigDecimal val, int scale) {
        this.rowAssembler.appendDecimalNotNull(val);
    }

    public void writeDate(LocalDate val) {
        this.rowAssembler.appendDateNotNull(val);
    }

    public void writeTime(LocalTime val) {
        this.rowAssembler.appendTimeNotNull(val);
    }

    public void writeTimestamp(Instant val) {
        this.rowAssembler.appendTimestampNotNull(val);
    }

    public void writeDateTime(LocalDateTime val) {
        this.rowAssembler.appendDateTimeNotNull(val);
    }
}

