/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.schema.row.Row;
import org.jetbrains.annotations.Nullable;

class RowReader
implements MarshallerReader {
    private final Row row;
    private int index;
    private final int @Nullable [] positions;

    RowReader(Row row) {
        this(row, null);
    }

    RowReader(Row row, int @Nullable [] positions) {
        this.row = row;
        this.positions = positions;
    }

    public void skipValue() {
        ++this.index;
    }

    public boolean readBoolean() {
        int idx = this.nextSchemaIndex();
        return this.row.booleanValue(idx);
    }

    public Boolean readBooleanBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.booleanValueBoxed(idx);
    }

    public byte readByte() {
        int idx = this.nextSchemaIndex();
        return this.row.byteValue(idx);
    }

    public Byte readByteBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.byteValueBoxed(idx);
    }

    public short readShort() {
        int idx = this.nextSchemaIndex();
        return this.row.shortValue(idx);
    }

    public Short readShortBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.shortValueBoxed(idx);
    }

    public int readInt() {
        int idx = this.nextSchemaIndex();
        return this.row.intValue(idx);
    }

    public Integer readIntBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.intValueBoxed(idx);
    }

    public long readLong() {
        int idx = this.nextSchemaIndex();
        return this.row.longValue(idx);
    }

    public Long readLongBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.longValueBoxed(idx);
    }

    public float readFloat() {
        int idx = this.nextSchemaIndex();
        return this.row.floatValue(idx);
    }

    public Float readFloatBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.floatValueBoxed(idx);
    }

    public double readDouble() {
        int idx = this.nextSchemaIndex();
        return this.row.doubleValue(idx);
    }

    public Double readDoubleBoxed() {
        int idx = this.nextSchemaIndex();
        return this.row.doubleValueBoxed(idx);
    }

    public String readString() {
        int idx = this.nextSchemaIndex();
        return this.row.stringValue(idx);
    }

    public UUID readUuid() {
        int idx = this.nextSchemaIndex();
        return this.row.uuidValue(idx);
    }

    public byte[] readBytes() {
        int idx = this.nextSchemaIndex();
        return this.row.bytesValue(idx);
    }

    public BigDecimal readBigDecimal(int scale) {
        int idx = this.nextSchemaIndex();
        return this.row.decimalValue(idx);
    }

    public LocalDate readDate() {
        int idx = this.nextSchemaIndex();
        return this.row.dateValue(idx);
    }

    public LocalTime readTime() {
        int idx = this.nextSchemaIndex();
        return this.row.timeValue(idx);
    }

    public Instant readTimestamp() {
        int idx = this.nextSchemaIndex();
        return this.row.timestampValue(idx);
    }

    public LocalDateTime readDateTime() {
        int idx = this.nextSchemaIndex();
        return this.row.dateTimeValue(idx);
    }

    private int nextSchemaIndex() {
        int i = this.index++;
        return this.positions == null ? i : this.positions[i];
    }
}

