/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang.util;

import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class IgniteNameUtils {
    @Deprecated
    private static final Pattern NAME_PATTER = Pattern.compile("^(?:\\p{Alpha}\\w*)(?:\\.\\p{Alpha}\\w*)?$");

    private IgniteNameUtils() {
    }

    @Deprecated(forRemoval=true)
    public static String parseSimpleName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        Tokenizer tokenizer = new Tokenizer(name);
        String parsedName = tokenizer.nextToken();
        if (tokenizer.hasNext()) {
            throw new IllegalArgumentException("Fully qualified name is not expected [name=" + name + "]");
        }
        return parsedName;
    }

    @Deprecated(forRemoval=true)
    public static String canonicalName(String schemaName, String objectName) {
        return IgniteNameUtils.quote(schemaName) + "." + IgniteNameUtils.quote(objectName);
    }

    @Deprecated(forRemoval=true)
    public static boolean canonicalOrSimpleName(String s) {
        return NAME_PATTER.matcher(s).matches();
    }

    @Deprecated
    public static String quote(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.chars().noneMatch(cp -> cp == 34)) {
            return "\"" + name + "\"";
        }
        StringBuilder sb = new StringBuilder(name.length() + 2).append('\"');
        for (int currentPosition = 0; currentPosition < name.length(); ++currentPosition) {
            char ch = name.charAt(currentPosition);
            if (ch == '\"') {
                sb.append('\"');
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString();
    }

    @Deprecated(forRemoval=true)
    public static String quoteIfNeeded(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.charAt(0) == '\"') {
            String simpleName = IgniteNameUtils.parseSimpleName(name);
            return name.equals(IgniteNameUtils.quote(simpleName)) ? name : IgniteNameUtils.quote(name);
        }
        if (!NAME_PATTER.matcher(name).matches()) {
            return IgniteNameUtils.quote(name);
        }
        return name.toUpperCase().equals(name) ? name : IgniteNameUtils.quote(name);
    }

    public static boolean identifierStart(int codePoint) {
        return Character.isAlphabetic(codePoint);
    }

    public static boolean identifierExtend(int codePoint) {
        return codePoint == 183 || (8454976 >> Character.getType(codePoint) & 1) != 0;
    }

    private static class Tokenizer {
        private int currentPosition;
        private final String source;

        public Tokenizer(String source) {
            this.source = source;
        }

        public boolean hasNext() {
            return this.currentPosition < this.source.length();
        }

        @Nullable
        public String nextToken() {
            boolean quoted;
            if (!this.hasNext()) {
                return null;
            }
            boolean bl = quoted = this.source.charAt(this.currentPosition) == '\"';
            if (quoted) {
                ++this.currentPosition;
            }
            int start = this.currentPosition;
            StringBuilder sb = new StringBuilder();
            while (this.currentPosition < this.source.length()) {
                if (this.currentChar() == '\"') {
                    if (!quoted) {
                        this.throwMalformedNameException();
                    }
                    if (this.hasNextChar() && this.nextChar() == '\"') {
                        sb.append(this.source, start, this.currentPosition + 1);
                        start = this.currentPosition + 2;
                        ++this.currentPosition;
                    } else {
                        if (!this.hasNextChar() || this.nextChar() == '.') {
                            sb.append(this.source, start, this.currentPosition);
                            this.currentPosition += 2;
                            return sb.toString();
                        }
                        this.throwMalformedNameException();
                    }
                } else if (!(quoted || this.currentChar() != '.' && this.currentChar() != ' ')) {
                    sb.append(this.source, start, this.currentPosition);
                    ++this.currentPosition;
                    return sb.toString().toUpperCase();
                }
                ++this.currentPosition;
            }
            if (quoted) {
                this.throwMalformedNameException();
            }
            return this.source.substring(start).toUpperCase();
        }

        private char currentChar() {
            return this.source.charAt(this.currentPosition);
        }

        private boolean hasNextChar() {
            return this.currentPosition + 1 < this.source.length();
        }

        private char nextChar() {
            return this.source.charAt(this.currentPosition + 1);
        }

        private void throwMalformedNameException() {
            throw new IllegalArgumentException("Malformed name [name=" + this.source + ", pos=" + this.currentPosition + "]");
        }
    }
}

