/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.IndexedItemSetMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedItemSetMapBase<K, S, M>
implements IndexedItemSetMap<K, S, M> {
    protected final HashMap<K, S> bag = new HashMap();

    public IndexedItemSetMapBase() {
        this(0);
    }

    public IndexedItemSetMapBase(int capacity) {
    }

    @Override
    @NotNull
    public abstract K mapKey(@NotNull M var1);

    @Override
    @NotNull
    public abstract S newSet();

    @Override
    public abstract boolean addSetItem(@NotNull S var1, int var2);

    @Override
    public abstract boolean removeSetItem(@NotNull S var1, int var2);

    @Override
    public abstract boolean containsSetItem(@NotNull S var1, int var2);

    @Override
    public boolean addItem(@NotNull M key, int item) {
        K mapKey = this.mapKey(key);
        S itemSet = this.bag.get(mapKey);
        if (itemSet == null) {
            itemSet = this.newSet();
            this.bag.put(mapKey, itemSet);
        }
        return this.addSetItem(itemSet, item);
    }

    @Override
    public boolean removeItem(@NotNull M key, int item) {
        K mapKey = this.mapKey(key);
        S itemSet = this.bag.get(mapKey);
        return itemSet != null && this.removeSetItem(itemSet, item);
    }

    @Override
    public boolean containsItem(@NotNull M key, int item) {
        K mapKey = this.mapKey(key);
        S itemSet = this.bag.get(mapKey);
        return itemSet != null && this.containsSetItem(itemSet, item);
    }

    @Override
    public int size() {
        return this.bag.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bag.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object o) {
        return this.bag.containsKey(o);
    }

    @Override
    public boolean containsValue(@Nullable Object o) {
        return this.bag.containsValue(o);
    }

    @Override
    @Nullable
    public S get(@Nullable Object o) {
        return this.bag.get(o);
    }

    @Override
    @Nullable
    public S put(@NotNull K k, @NotNull S vs) {
        return this.bag.put(k, vs);
    }

    @Override
    @Nullable
    public S remove(@Nullable Object o) {
        return this.bag.remove(o);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends S> map) {
        this.bag.putAll(map);
    }

    @Override
    public void clear() {
        this.bag.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.bag.keySet();
    }

    @Override
    @NotNull
    public Collection<S> values() {
        return this.bag.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, S>> entrySet() {
        return this.bag.entrySet();
    }
}

