/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LiteBlockingWaitStrategy
implements WaitStrategy {
    private final Object mutex = new Object();
    private final AtomicBoolean signalNeeded = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence) {
            Object object = this.mutex;
            synchronized (object) {
                do {
                    this.signalNeeded.getAndSet(true);
                    if (cursorSequence.get() >= sequence) break;
                    barrier.checkAlert();
                    this.mutex.wait();
                } while (cursorSequence.get() < sequence);
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
            Thread.onSpinWait();
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAllWhenBlocking() {
        if (this.signalNeeded.getAndSet(false)) {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
    }

    public String toString() {
        return "LiteBlockingWaitStrategy{mutex=" + this.mutex + ", signalNeeded=" + this.signalNeeded + "}";
    }
}

