/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class HandshakeStartMessageDeserializer
implements MessageDeserializer<HandshakeStartMessage> {
    private final HandshakeStartMessageBuilder msg;

    HandshakeStartMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartMessage();
    }

    public Class<HandshakeStartMessage> klass() {
        return HandshakeStartMessage.class;
    }

    public HandshakeStartMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Serializable tmp = reader.readUuid("serverClusterId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serverClusterId((UUID)tmp);
                reader.incrementState();
            }
            case 1: {
                Serializable tmp = (ClusterNodeMessage)reader.readMessage("serverNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serverNode((ClusterNodeMessage)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartMessage.class);
    }
}

