/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.http.server.netty.jackson.JsonViewCodecResolver;
import io.micronaut.json.JsonConfiguration;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.web.router.RouteInfo;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Requirements(value={@Requires(beans={JsonConfiguration.class}), @Requires(classes={JsonView.class}), @Requires(property="jackson.json-view.enabled")})
@Filter(value={"/**"})
public class JsonViewServerFilter
implements HttpServerFilter {
    public static final String PROPERTY_JSON_VIEW_ENABLED = "jackson.json-view.enabled";
    private final JsonViewCodecResolver codecFactory;
    private final ExecutorService executorService;

    public JsonViewServerFilter(JsonViewCodecResolver jsonViewCodecResolver, @Named(value="io") ExecutorService executorService) {
        this.codecFactory = jsonViewCodecResolver;
        this.executorService = executorService;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        Optional viewClass;
        RouteInfo routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
        Publisher responsePublisher = chain.proceed(request);
        if (routeInfo != null && (viewClass = routeInfo.findAnnotation(JsonView.class).flatMap(AnnotationValue::classValue)).isPresent()) {
            return Flux.from((Publisher)responsePublisher).switchMap(response -> {
                Optional optionalBody = response.getBody();
                if (optionalBody.isPresent()) {
                    Object body = optionalBody.get();
                    JsonMediaTypeCodec codec = this.codecFactory.resolveJsonViewCodec((Class)viewClass.get());
                    if (Publishers.isConvertibleToPublisher(body)) {
                        Publisher pub = (Publisher)Publishers.convertPublisher(body, Publisher.class);
                        response.body((Object)Flux.from((Publisher)pub).map(arg_0 -> JsonViewServerFilter.lambda$doFilter$0((MediaTypeCodec)codec, routeInfo, arg_0)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.executorService)));
                    } else {
                        return Mono.fromCallable(() -> JsonViewServerFilter.lambda$doFilter$1((MediaTypeCodec)codec, routeInfo, body, response)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.executorService));
                    }
                }
                return Flux.just((Object)response);
            });
        }
        return responsePublisher;
    }

    public int getOrder() {
        return ServerFilterPhase.RENDERING.order();
    }

    private static /* synthetic */ MutableHttpResponse lambda$doFilter$1(MediaTypeCodec codec, RouteInfo routeInfo, Object body, MutableHttpResponse response) throws Exception {
        byte[] encoded = codec.encode(routeInfo.getBodyType(), body);
        response.body((Object)encoded);
        return response;
    }

    private static /* synthetic */ byte[] lambda$doFilter$0(MediaTypeCodec codec, RouteInfo routeInfo, Object o) {
        return codec.encode(routeInfo.getBodyType(), o);
    }
}

