/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.LeaderElectionListener;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.network.ClusterNode;

public class RaftGroupEventsClientListener {
    private static final IgniteLogger LOG = Loggers.forClass(RaftGroupEventsClientListener.class);
    private final Map<ReplicationGroupId, List<LeaderElectionListener>> leaderElectionListeners = new ConcurrentHashMap<ReplicationGroupId, List<LeaderElectionListener>>();

    public void addLeaderElectionListener(ReplicationGroupId groupId, LeaderElectionListener listener) {
        this.leaderElectionListeners.computeIfAbsent(groupId, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public void removeLeaderElectionListener(ReplicationGroupId groupId, LeaderElectionListener listener) {
        this.leaderElectionListeners.computeIfPresent(groupId, (k, listeners) -> {
            listeners.remove(listener);
            return listeners;
        });
    }

    public void onLeaderElected(ReplicationGroupId groupId, ClusterNode leader, long term) {
        List<LeaderElectionListener> listeners = this.leaderElectionListeners.get(groupId);
        if (listeners != null) {
            for (LeaderElectionListener listener : listeners) {
                try {
                    listener.onLeaderElected(leader, term);
                }
                catch (Exception e) {
                    LOG.warn("Failed to notify leader election listener for group=" + String.valueOf(groupId), (Throwable)e);
                }
            }
        }
    }
}

