/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaBuilder;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaSerializer;

public class SnapshotMetaImpl
implements RaftOutter.SnapshotMeta,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2001;
    @IgniteToStringInclude
    private final long lastIncludedIndex;
    @IgniteToStringInclude
    private final long lastIncludedTerm;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final Collection<String> oldLearnersList;
    @IgniteToStringInclude
    private final Collection<String> oldPeersList;
    @IgniteToStringInclude
    private final Collection<String> peersList;

    private SnapshotMetaImpl(long lastIncludedIndex, long lastIncludedTerm, Collection<String> learnersList, Collection<String> oldLearnersList, Collection<String> oldPeersList, Collection<String> peersList) {
        this.lastIncludedIndex = lastIncludedIndex;
        this.lastIncludedTerm = lastIncludedTerm;
        this.learnersList = learnersList;
        this.oldLearnersList = oldLearnersList;
        this.oldPeersList = oldPeersList;
        this.peersList = peersList;
    }

    @Override
    public long lastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    @Override
    public long lastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public Collection<String> oldLearnersList() {
        return this.oldLearnersList;
    }

    @Override
    public Collection<String> oldPeersList() {
        return this.oldPeersList;
    }

    @Override
    public Collection<String> peersList() {
        return this.peersList;
    }

    public MessageSerializer serializer() {
        return SnapshotMetaSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(SnapshotMetaImpl.class, (Object)this);
    }

    public short messageType() {
        return 2001;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotMetaImpl otherMessage = (SnapshotMetaImpl)other;
        return Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.oldLearnersList, otherMessage.oldLearnersList) && Objects.equals(this.oldPeersList, otherMessage.oldPeersList) && Objects.equals(this.peersList, otherMessage.peersList) && this.lastIncludedIndex == otherMessage.lastIncludedIndex && this.lastIncludedTerm == otherMessage.lastIncludedTerm;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.lastIncludedIndex, this.lastIncludedTerm, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList);
        return result;
    }

    public SnapshotMetaImpl clone() {
        try {
            return (SnapshotMetaImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotMetaBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SnapshotMetaBuilder {
        private long lastIncludedIndex;
        private long lastIncludedTerm;
        private Collection<String> learnersList;
        private Collection<String> oldLearnersList;
        private Collection<String> oldPeersList;
        private Collection<String> peersList;

        private Builder() {
        }

        @Override
        public SnapshotMetaBuilder lastIncludedIndex(long lastIncludedIndex) {
            this.lastIncludedIndex = lastIncludedIndex;
            return this;
        }

        @Override
        public SnapshotMetaBuilder lastIncludedTerm(long lastIncludedTerm) {
            this.lastIncludedTerm = lastIncludedTerm;
            return this;
        }

        @Override
        public SnapshotMetaBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public SnapshotMetaBuilder oldLearnersList(Collection<String> oldLearnersList) {
            this.oldLearnersList = oldLearnersList;
            return this;
        }

        @Override
        public SnapshotMetaBuilder oldPeersList(Collection<String> oldPeersList) {
            this.oldPeersList = oldPeersList;
            return this;
        }

        @Override
        public SnapshotMetaBuilder peersList(Collection<String> peersList) {
            this.peersList = peersList;
            return this;
        }

        @Override
        public long lastIncludedIndex() {
            return this.lastIncludedIndex;
        }

        @Override
        public long lastIncludedTerm() {
            return this.lastIncludedTerm;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public Collection<String> oldLearnersList() {
            return this.oldLearnersList;
        }

        @Override
        public Collection<String> oldPeersList() {
            return this.oldPeersList;
        }

        @Override
        public Collection<String> peersList() {
            return this.peersList;
        }

        @Override
        public RaftOutter.SnapshotMeta build() {
            return new SnapshotMetaImpl(this.lastIncludedIndex, this.lastIncludedTerm, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList);
        }
    }
}

