/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.recovery.system;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

@Schema(description="Reset cluster.")
public class ResetClusterRequest {
    @Schema(description="Names of the proposed CMG nodes. Optional if the MG group is being repaired. If not specified, the current CMG nodes are used.")
    @IgniteToStringInclude
    @Nullable
    private final List<String> cmgNodeNames;
    @Schema(description="Number of nodes in the voting member set of the Metastorage RAFT group.")
    @IgniteToStringInclude
    @Nullable
    private final Integer metastorageReplicationFactor;

    @JsonCreator
    public ResetClusterRequest(@JsonProperty(value="cmgNodeNames") @Nullable List<String> cmgNodeNames, @JsonProperty(value="metastorageReplicationFactor") @Nullable Integer metastorageReplicationFactor) {
        this.cmgNodeNames = cmgNodeNames == null ? null : List.copyOf(cmgNodeNames);
        this.metastorageReplicationFactor = metastorageReplicationFactor;
    }

    @JsonGetter(value="cmgNodeNames")
    @Nullable
    public List<String> cmgNodeNames() {
        return this.cmgNodeNames;
    }

    @JsonGetter(value="metastorageReplicationFactor")
    @Nullable
    public Integer metastorageReplicationFactor() {
        return this.metastorageReplicationFactor;
    }

    public String toString() {
        return S.toString((Object)this);
    }

    public boolean metastorageRepairRequested() {
        return this.metastorageReplicationFactor != null;
    }
}

