/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.PayloadInputChannel;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.KeyValuePojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.marshaller.ClientMarshallerReader;
import org.apache.ignite.internal.marshaller.ClientMarshallerWriter;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.apache.ignite.internal.marshaller.MarshallerWriter;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.marshaller.ValidationUtils;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.lang.UnexpectedNullValueException;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class ClientKeyValueView<K, V>
extends AbstractClientView<Map.Entry<K, V>>
implements KeyValueView<K, V> {
    private final ClientRecordSerializer<K> keySer;
    private final ClientRecordSerializer<V> valSer;

    ClientKeyValueView(ClientTable tbl, ClientSql sql, Mapper<K> keyMapper, Mapper<V> valMapper) {
        super(tbl, sql);
        assert (keyMapper != null);
        assert (valMapper != null);
        this.keySer = new ClientRecordSerializer<K>(tbl.tableId(), keyMapper);
        this.valSer = new ClientRecordSerializer<V>(tbl.tableId(), valMapper);
    }

    public V get(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return (V)ViewUtils.sync(this.doGet(tx, key, "getNullable"));
    }

    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGet(tx, key, "getNullableAsync");
    }

    private CompletableFuture<V> doGet(@Nullable Transaction tx, K key, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullable");
        return (NullableValue)ViewUtils.sync(this.doGetNullable(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAsync");
        return this.doGetNullable(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullable(@Nullable Transaction tx, K key) {
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public V getOrDefault(@Nullable Transaction tx, K key, V defaultValue) {
        return (V)ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, V defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutInOpAsync(12, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), defaultValue, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Map)ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyMapCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), this::readGetAllResponse, Collections.emptyMap(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    public boolean contains(@Nullable Transaction tx, K key) {
        return (Boolean)ViewUtils.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(33, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Boolean)ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(67, (s, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    public void put(@Nullable Transaction tx, K key, V val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(10, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        if (pairs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        for (Map.Entry<K, V> e : pairs.entrySet()) {
            Objects.requireNonNull(e.getKey(), "key");
            ValidationUtils.validateNullableValue(e.getValue(), (Class)this.valSer.mapper().targetType());
        }
        return this.tbl.doSchemaOutOpAsync(13, (s, w) -> {
            this.writeSchemaAndTx((ClientSchema)s, (PayloadOutputChannel)w, tx);
            w.out().packInt(pairs.size());
            for (Map.Entry e : pairs.entrySet()) {
                this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, e.getKey(), e.getValue());
            }
        }, r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), pairs.keySet().iterator().next()), tx);
    }

    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return (V)ViewUtils.sync(this.doGetAndPut(tx, key, val, "getNullableAndPut"));
    }

    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.doGetAndPut(tx, key, val, "getNullableAndPutAsync");
    }

    private CompletableFuture<V> doGetAndPut(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndPut");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return (NullableValue)ViewUtils.sync(this.doGetNullableAndPut(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndPutAsync");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.doGetNullableAndPut(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.tbl.doSchemaOutInOpAsync(16, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public boolean putIfAbsent(@Nullable Transaction tx, K key, V val) {
        return (Boolean)ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(18, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public boolean remove(@Nullable Transaction tx, K key) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return (Boolean)ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.tbl.doSchemaOutOpAsync(28, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(30, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return (Collection)ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.emptyCollectionCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s, w) -> this.keySer.writeRecs(tx, keys, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> this.keySer.readRecs((ClientSchema)s, r.in(), false, TuplePart.KEY), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), keys.iterator().next()), tx);
    }

    public V getAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return (V)ViewUtils.sync(this.doGetAndRemove(tx, key, "getNullableAndRemove"));
    }

    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGetAndRemove(tx, key, "getNullableAndRemoveAsync");
    }

    private CompletableFuture<V> doGetAndRemove(@Nullable Transaction tx, K key, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndRemove");
        return (NullableValue)ViewUtils.sync(this.doGetNullableAndRemove(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndRemoveAsync");
        return this.doGetNullableAndRemove(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.tbl.doSchemaOutInOpAsync(32, (s, w) -> this.keySer.writeRec(tx, key, (ClientSchema)s, (PayloadOutputChannel)w, TuplePart.KEY), (s, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public boolean replace(@Nullable Transaction tx, K key, V val) {
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, K key, V oldVal, V newVal) {
        Objects.requireNonNull(key, "key");
        return (Boolean)ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(22, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, V oldVal, V newVal) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(oldVal, (Class)this.valSer.mapper().targetType());
        ValidationUtils.validateNullableValue(newVal, (Class)this.valSer.mapper().targetType());
        return this.tbl.doSchemaOutOpAsync(24, (s, w) -> {
            this.writeSchemaAndTx((ClientSchema)s, (PayloadOutputChannel)w, tx);
            this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, key, oldVal);
            this.writeKeyValueRaw((ClientSchema)s, (PayloadOutputChannel)w, key, newVal);
        }, r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public V getAndReplace(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return (V)ViewUtils.sync(this.doGetAndReplace(tx, key, val, "getNullableAndReplace"));
    }

    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.doGetAndReplace(tx, key, val, "getNullableAndReplaceAsync");
    }

    private CompletableFuture<V> doGetAndReplace(@Nullable Transaction tx, K key, V val, String altMethod) {
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> ClientKeyValueView.throwIfNull(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL), altMethod), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndReplace");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return (NullableValue)ViewUtils.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation((Class)this.valSer.mapper().targetType(), (String)"getNullableAndReplaceAsync");
        ValidationUtils.validateNullableValue(val, (Class)this.valSer.mapper().targetType());
        return this.doGetNullableAndReplace(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndReplace(@Nullable Transaction tx, K key, V val) {
        return this.tbl.doSchemaOutInOpAsync(26, (s, w) -> this.writeKeyValue((ClientSchema)s, (PayloadOutputChannel)w, tx, key, val), (s, r) -> NullableValue.of(this.valSer.readRec((ClientSchema)s, r.in(), TuplePart.VAL, TuplePart.KEY_AND_VAL)), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.keySer.mapper(), key), tx);
    }

    private void writeKeyValue(ClientSchema s, PayloadOutputChannel w, @Nullable Transaction tx, K key, @Nullable V val) {
        this.writeSchemaAndTx(s, w, tx);
        this.writeKeyValueRaw(s, w, key, val);
    }

    private void writeKeyValueRaw(ClientSchema s, PayloadOutputChannel w, K key, @Nullable V val) {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(s.columns().length);
        BitSet noValueSet = new BitSet();
        ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
        Marshaller keyMarsh = s.getMarshaller(this.keySer.mapper(), TuplePart.KEY, false);
        Marshaller valMarsh = s.getMarshaller(this.valSer.mapper(), TuplePart.VAL, false);
        for (ClientColumn column : s.columns()) {
            if (column.key()) {
                keyMarsh.writeField(key, (MarshallerWriter)writer, column.keyIndex());
                continue;
            }
            valMarsh.writeField(val, (MarshallerWriter)writer, column.valIndex());
        }
        w.out().packBinaryTuple(builder, noValueSet);
    }

    private void writeSchemaAndTx(ClientSchema s, PayloadOutputChannel w, @Nullable Transaction tx) {
        w.out().packInt(this.tbl.tableId());
        ClientTable.writeTx(tx, w);
        w.out().packInt(s.version());
    }

    private HashMap<K, V> readGetAllResponse(ClientSchema schema, PayloadInputChannel in) {
        int cnt = in.in().unpackInt();
        LinkedHashMap<Object, Object> res = new LinkedHashMap<Object, Object>(cnt);
        Marshaller keyMarsh = schema.getMarshaller(this.keySer.mapper(), TuplePart.KEY);
        Marshaller valMarsh = schema.getMarshaller(this.valSer.mapper(), TuplePart.VAL);
        for (int i = 0; i < cnt; ++i) {
            if (!in.in().unpackBoolean()) continue;
            BinaryTupleReader tupleReader = new BinaryTupleReader(schema.columns().length, in.in().readBinaryUnsafe());
            ClientMarshallerReader keyReader = new ClientMarshallerReader(tupleReader, schema.keyColumns(), TuplePart.KEY_AND_VAL);
            ClientMarshallerReader valReader = new ClientMarshallerReader(tupleReader, schema.valColumns(), TuplePart.KEY_AND_VAL);
            res.put(keyMarsh.readObject((MarshallerReader)keyReader, null), valMarsh.readObject((MarshallerReader)valReader, null));
        }
        return res;
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        KeyValuePojoStreamerPartitionAwarenessProvider provider = new KeyValuePojoStreamerPartitionAwarenessProvider(this.tbl, this.keySer.mapper());
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s, w) -> {
            w.out().packInt(this.tbl.tableId());
            w.out().packInt(partition.intValue());
            w.out().packBitSetNullable(deleted);
            w.out().packInt(s.version());
            w.out().packInt(items.size());
            int i = 0;
            Marshaller keyMarsh = s.getMarshaller(this.keySer.mapper(), TuplePart.KEY, false);
            Marshaller valMarsh = s.getMarshaller(this.valSer.mapper(), TuplePart.VAL, false);
            BitSet noValueSet = new BitSet();
            for (Map.Entry e : items) {
                boolean del = deleted != null && deleted.get(i++);
                int colCount = del ? s.keyColumns().length : s.columns().length;
                noValueSet.clear();
                BinaryTupleBuilder builder = new BinaryTupleBuilder(colCount);
                ClientMarshallerWriter writer = new ClientMarshallerWriter(builder, noValueSet);
                keyMarsh.writeObject(e.getKey(), (MarshallerWriter)writer);
                if (!del) {
                    valMarsh.writeObject(e.getValue(), (MarshallerWriter)writer);
                }
                w.out().packBinaryTuple(builder, noValueSet);
            }
        }, r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    public <E, P, R, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, Map.Entry<K, V>> keyFunc, Function<E, P> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options, A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new KeyValuePojoStreamerPartitionAwarenessProvider(this.tbl, this.keySer.mapper()), this.tbl, resultSubscriber, receiver.units(), receiver.receiverClassName(), receiverArg, receiver.argumentMarshaller());
    }

    @Override
    protected Function<SqlRow, Map.Entry<K, V>> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] keyCols = ClientKeyValueView.columnNames(schema.keyColumns());
        String[] valCols = ClientKeyValueView.columnNames(schema.valColumns());
        Marshaller keyMarsh = schema.getMarshaller(this.keySer.mapper(), TuplePart.KEY, true);
        Marshaller valMarsh = schema.getMarshaller(this.valSer.mapper(), TuplePart.VAL, true);
        return row -> new IgniteBiTuple(keyMarsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, keyCols)), null), valMarsh.readObject((MarshallerReader)new TupleReader((Tuple)new SqlRowProjection(row, meta, valCols)), null));
    }

    private static <T> T throwIfNull(T obj, String altMethod) {
        if (obj == null) {
            throw new UnexpectedNullValueException(IgniteStringFormatter.format((String)"Got unexpected null value: use `{}` sibling method instead.", (Object[])new Object[]{altMethod}));
        }
        return obj;
    }
}

