/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.BitField;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public final class LineInfo {
    public static final Flags BLANK_PREFIX = Flags.BLANK_PREFIX;
    public static final Flags BLANK_TEXT = Flags.BLANK_TEXT;
    public static final Flags PREFORMATTED = Flags.PREFORMATTED;
    public static final int F_PREFORMATTED = BitFieldSet.intMask((Enum)Flags.PREFORMATTED);
    public static final int F_BLANK_PREFIX = BitFieldSet.intMask((Enum)Flags.BLANK_PREFIX);
    public static final int F_BLANK_TEXT = BitFieldSet.intMask((Enum)Flags.BLANK_TEXT);
    public static final LineInfo NULL = new LineInfo(BasedSequence.NULL, -1, 0, 0, 0, 0, 0, 0, true, true, Preformatted.NONE);
    public final CharSequence lineSeq;
    public final int index;
    public final int prefixLength;
    public final int textLength;
    public final int length;
    public final int sumPrefixLength;
    public final int sumTextLength;
    public final int sumLength;
    public final int flags;

    private LineInfo(@NotNull CharSequence lineSeq, int index, int prefixLength, int textLength, int length, int sumPrefixLength, int sumTextLength, int sumLength, boolean isBlankPrefix, boolean isBlankText, @NotNull Preformatted preformatted) {
        assert (lineSeq == BasedSequence.NULL && index == -1 || prefixLength + textLength < length) : "Line must be terminated by an EOL";
        assert (lineSeq.length() == length);
        this.lineSeq = lineSeq;
        this.index = index;
        this.prefixLength = prefixLength;
        this.textLength = textLength;
        this.length = length;
        this.sumPrefixLength = sumPrefixLength + prefixLength;
        this.sumTextLength = sumTextLength + textLength;
        this.sumLength = sumLength + length;
        this.flags = (isBlankPrefix || prefixLength == 0 ? F_BLANK_PREFIX : 0) | (isBlankText || textLength == 0 ? F_BLANK_TEXT : 0) | preformatted.ordinal();
    }

    public boolean needAggregateUpdate(LineInfo other) {
        return this.sumPrefixLength != other.sumPrefixLength || this.sumTextLength != other.sumTextLength || this.sumLength != other.sumLength;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isNotNull() {
        return this != NULL;
    }

    public boolean isBlankPrefix() {
        return BitFieldSet.any((long)this.flags, (long)F_BLANK_PREFIX);
    }

    public boolean isBlankText() {
        return BitFieldSet.any((long)this.flags, (long)F_BLANK_TEXT);
    }

    public boolean isPreformatted() {
        return BitFieldSet.any((long)this.flags, (long)F_PREFORMATTED);
    }

    @NotNull
    public Preformatted getPreformatted() {
        return Preformatted.get(this.flags);
    }

    public boolean isBlankTextAndPrefix() {
        return BitFieldSet.all((long)this.flags, (long)(F_BLANK_PREFIX | F_BLANK_TEXT));
    }

    public int getTextStart() {
        return this.prefixLength;
    }

    public int getTextEnd() {
        return this.prefixLength + this.textLength;
    }

    @NotNull
    public BasedSequence getLine() {
        return this.lineSeq instanceof BasedSequence ? (BasedSequence)this.lineSeq : BasedSequence.of(this.lineSeq);
    }

    @NotNull
    public BasedSequence getPrefix() {
        return this.getLine().subSequence(0, this.prefixLength);
    }

    @NotNull
    public BasedSequence getTextNoEOL() {
        return this.getLine().subSequence(this.prefixLength, this.prefixLength + this.textLength);
    }

    @NotNull
    public BasedSequence getText() {
        return this.getLine().subSequence(this.prefixLength, this.length);
    }

    @NotNull
    public BasedSequence getLineNoEOL() {
        return this.getLine().subSequence(0, this.prefixLength + this.textLength);
    }

    @NotNull
    public BasedSequence getEOL() {
        return this.getLine().subSequence(this.prefixLength + this.textLength, this.length);
    }

    public String toString() {
        return "LineInfo{i=" + this.index + ", pl=" + this.prefixLength + ", tl=" + this.textLength + ", l=" + this.length + ", sumPl=" + this.sumPrefixLength + ", sumTl=" + this.sumTextLength + ", sumL=" + this.sumLength + (this.flags != 0 ? "," + (this.isBlankPrefix() ? " bp" : "") + (this.isBlankText() ? " bt" : "") + (this.isPreformatted() ? " p" : "") : "") + ", '" + Utils.escapeJavaString((CharSequence)this.lineSeq) + "'" + '}';
    }

    @NotNull
    public static LineInfo create(@NotNull CharSequence line, int prefixLength, int textLength, int length, boolean isBlankPrefix, boolean isBlankText, @NotNull Preformatted preformatted) {
        return new LineInfo(line, 0, prefixLength, textLength, length, 0, 0, 0, isBlankPrefix, isBlankText, preformatted);
    }

    @NotNull
    public static LineInfo create(@NotNull CharSequence line, @NotNull LineInfo prevInfo, int prefixLength, int textLength, int length, boolean isBlankPrefix, boolean isBlankText, @NotNull Preformatted preformatted) {
        return new LineInfo(line, prevInfo.index + 1, prefixLength, textLength, length, prevInfo.sumPrefixLength, prevInfo.sumTextLength, prevInfo.sumLength, isBlankPrefix, isBlankText, preformatted);
    }

    @NotNull
    public static LineInfo create(@NotNull LineInfo prevInfo, @NotNull LineInfo info) {
        return new LineInfo(info.lineSeq, prevInfo.index + 1, info.prefixLength, info.textLength, info.length, prevInfo.sumPrefixLength, prevInfo.sumTextLength, prevInfo.sumLength, info.isBlankPrefix(), info.isBlankText(), info.getPreformatted());
    }

    public static enum Preformatted {
        NONE,
        FIRST,
        BODY,
        LAST;

        final int mask = BitFieldSet.setBitField((int)0, (Enum)Flags.PREFORMATTED, (int)this.ordinal());

        @NotNull
        static Preformatted get(int flags) {
            int preformatted = flags & F_PREFORMATTED;
            if (preformatted == Preformatted.FIRST.mask) {
                return FIRST;
            }
            if (preformatted == Preformatted.BODY.mask) {
                return BODY;
            }
            if (preformatted == Preformatted.LAST.mask) {
                return LAST;
            }
            return NONE;
        }
    }

    public static enum Flags implements BitField
    {
        PREFORMATTED(2),
        BLANK_PREFIX,
        BLANK_TEXT;

        final int bits;

        private Flags() {
            this(1);
        }

        private Flags(int bits) {
            this.bits = bits;
        }

        public int getBits() {
            return this.bits;
        }
    }
}

