/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.server.Value;
import org.jetbrains.annotations.Nullable;

class RocksStorageUtils {
    private static final VarHandle LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);

    RocksStorageUtils() {
    }

    static byte[] longToBytes(long value) {
        byte[] buffer = new byte[8];
        RocksStorageUtils.putLongToBytes(value, buffer, 0);
        return buffer;
    }

    static void putLongToBytes(long value, byte[] array, int position) {
        assert (position + 8 <= array.length) : "pos=" + position + ", arr.len=" + array.length;
        LONG_ARRAY_HANDLE.set(array, position, value);
    }

    static long bytesToLong(byte[] array) {
        assert (array.length == 8);
        return RocksStorageUtils.bytesToLong(array, 0);
    }

    static long bytesToLong(byte[] array, int offset) {
        assert (offset + 8 <= array.length) : "off=" + offset + ", arr.len=" + array.length;
        return LONG_ARRAY_HANDLE.get(array, offset);
    }

    static byte[] keyToRocksKey(long revision, byte[] key) {
        byte[] buffer = new byte[8 + key.length];
        LONG_ARRAY_HANDLE.set(buffer, 0, revision);
        System.arraycopy(key, 0, buffer, 8, key.length);
        return buffer;
    }

    static byte[] rocksKeyToBytes(byte[] rocksKey) {
        return Arrays.copyOfRange(rocksKey, 8, rocksKey.length);
    }

    static long revisionFromRocksKey(byte[] rocksKey) {
        return LONG_ARRAY_HANDLE.get(rocksKey, 0);
    }

    static long timestampFromRocksValue(byte[] rocksValue) {
        return LONG_ARRAY_HANDLE.get(rocksValue, 0);
    }

    static Value bytesToValue(byte[] valueBytes) {
        assert (valueBytes.length > 8);
        int pos = 0;
        long operationTimestamp = LONG_ARRAY_HANDLE.get(valueBytes, pos);
        boolean hasValue = valueBytes[pos += 8] != 0;
        byte[] val = hasValue ? Arrays.copyOfRange(valueBytes, ++pos, valueBytes.length) : Value.TOMBSTONE;
        return new Value(val, HybridTimestamp.hybridTimestamp((long)operationTimestamp));
    }

    static byte[] valueToBytes(byte[] value, HybridTimestamp operationTimestamp) {
        byte[] bytes = new byte[9 + value.length];
        int pos = 0;
        LONG_ARRAY_HANDLE.set(bytes, pos, operationTimestamp.longValue());
        bytes[pos += 8] = (byte)(value != Value.TOMBSTONE ? 1 : 0);
        System.arraycopy(value, 0, bytes, ++pos, value.length);
        return bytes;
    }

    static long[] getAsLongs(byte[] bytes) {
        assert (bytes.length % 8 == 0);
        int size = bytes.length / 8;
        long[] res = new long[size];
        for (int i = 0; i < size; ++i) {
            res[i] = LONG_ARRAY_HANDLE.get(bytes, i * 8);
        }
        return res;
    }

    static byte[] appendLong(byte @Nullable [] bytes, long value) {
        if (bytes == null) {
            return RocksStorageUtils.longToBytes(value);
        }
        byte[] result = Arrays.copyOf(bytes, bytes.length + 8);
        LONG_ARRAY_HANDLE.set(result, bytes.length, value);
        return result;
    }

    static byte[] longsToBytes(int valuesOffset, long ... values) {
        assert (valuesOffset < values.length) : "off=" + valuesOffset + ", arr.len=" + values.length;
        byte[] result = new byte[(values.length - valuesOffset) * 8];
        int srcIdx = valuesOffset;
        int dstIdx = 0;
        while (srcIdx < values.length) {
            long val = values[srcIdx];
            LONG_ARRAY_HANDLE.set(result, dstIdx * 8, val);
            ++srcIdx;
            ++dstIdx;
        }
        return result;
    }
}

