/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.storage;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.HashIndexStorage;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.jetbrains.annotations.Nullable;

public class NullMvTableStorage
implements MvTableStorage {
    private final StorageTableDescriptor tableDescriptor;

    public NullMvTableStorage(StorageTableDescriptor tableDescriptor) {
        this.tableDescriptor = tableDescriptor;
    }

    public CompletableFuture<MvPartitionStorage> createMvPartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Nullable
    public MvPartitionStorage getMvPartition(int partitionId) {
        return (MvPartitionStorage)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> destroyPartition(int partitionId) throws StorageException {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    public SortedIndexStorage getOrCreateSortedIndex(int partitionId, StorageSortedIndexDescriptor indexDescriptor) {
        return (SortedIndexStorage)this.throwNoPartitionsException();
    }

    public HashIndexStorage getOrCreateHashIndex(int partitionId, StorageHashIndexDescriptor indexDescriptor) {
        return (HashIndexStorage)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> destroyIndex(int indexId) {
        return (CompletableFuture)this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any index destruction events, or storage profile addition is not handled property");
    }

    public boolean isVolatile() {
        return (Boolean)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> destroy() {
        return (CompletableFuture)this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any table destruction events, or storage profile addition is not handled property");
    }

    public CompletableFuture<Void> startRebalancePartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> abortRebalancePartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> finishRebalancePartition(int partitionId, MvPartitionMeta partitionMeta) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    public CompletableFuture<Void> clearPartition(int partitionId) {
        return (CompletableFuture)this.throwNoPartitionsException();
    }

    @Nullable
    public IndexStorage getIndex(int partitionId, int indexId) {
        return (IndexStorage)this.throwNoPartitionsException();
    }

    public StorageTableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    public void close() throws Exception {
    }

    private <T> T throwNoPartitionsException() {
        return this.throwNoStorageEngineException("Table uses an unknown storage profile or engine, so current node either should not receive any assignments, or storage profile addition is not handled property");
    }

    private <T> T throwNoStorageEngineException(String errorMessage) {
        throw new StorageException(errorMessage + " [tableId=" + this.tableDescriptor.getId() + "]");
    }
}

