/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.disaster;

import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSetBuilder;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateEnum;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite.internal.table.distributed.disaster.LocalPartitionStateEnumWithLogIndex;
import org.jetbrains.annotations.Nullable;

class PartitionStatesMetricSource
implements MetricSource {
    private final String metricSourceName;
    private final int tableId;
    private final DisasterRecoveryManager disasterRecoveryManager;
    private boolean enabled;

    PartitionStatesMetricSource(CatalogTableDescriptor tableDescriptor, DisasterRecoveryManager disasterRecoveryManager) {
        this.tableId = tableDescriptor.id();
        this.disasterRecoveryManager = disasterRecoveryManager;
        this.metricSourceName = String.format("partition.states.zone.%s.table.%s", tableDescriptor.zoneId(), tableDescriptor.id());
    }

    public String name() {
        return this.metricSourceName;
    }

    @Nullable
    public synchronized MetricSet enable() {
        if (this.enabled) {
            return null;
        }
        MetricSetBuilder builder = new MetricSetBuilder(this.metricSourceName);
        builder.longGauge("UnavailablePartitionCount", "Count of partitions not yet started.", () -> this.calculatePartitionCountByLocalState(LocalPartitionStateEnum.UNAVAILABLE));
        builder.longGauge("HealthyPartitionCount", "Count of living partitions with a healthy state machine.", () -> this.calculatePartitionCountByLocalState(LocalPartitionStateEnum.HEALTHY));
        builder.longGauge("InitializingPartitionCount", "Count of partitions that are starting right now.", () -> this.calculatePartitionCountByLocalState(LocalPartitionStateEnum.INITIALIZING));
        builder.longGauge("InstallingSnapshotPartitionCount", "Count of partitions that installing Raft snapshots from the leader.", () -> this.calculatePartitionCountByLocalState(LocalPartitionStateEnum.INSTALLING_SNAPSHOT));
        builder.longGauge("BrokenPartitionCount", "Count of broken partitions.", () -> this.calculatePartitionCountByLocalState(LocalPartitionStateEnum.BROKEN));
        return builder.build();
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized boolean enabled() {
        return this.enabled;
    }

    private long calculatePartitionCountByLocalState(LocalPartitionStateEnum state) {
        long[] count = new long[]{0L};
        this.disasterRecoveryManager.raftManager.forEach((raftNodeId, raftGroupService) -> {
            TablePartitionId tablePartitionId;
            if (raftNodeId.groupId() instanceof TablePartitionId && (tablePartitionId = (TablePartitionId)raftNodeId.groupId()).tableId() == this.tableId) {
                LocalPartitionStateEnumWithLogIndex localPartitionStateWithLogIndex = LocalPartitionStateEnumWithLogIndex.of(raftGroupService.getRaftNode());
                if (localPartitionStateWithLogIndex.state == state) {
                    count[0] = count[0] + 1L;
                }
            }
        });
        return count[0];
    }
}

